"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFieldUpgradeSpecifier = void 0;
var _assert_diffable_fields_match_rule_type = require("./assert_diffable_fields_match_rule_type");
var _diffable_rule_fields_mappings = require("./diffable_rule_fields_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates a field upgrade specifier for a given field in PrebuiltRuleAsset.
 *
 * This function determines how a specific field should be upgraded based on the
 * upgrade request body and the pick_version at global, rule and field-levels,
 * when the mode is SPECIFIC_RULES.
 */
const createFieldUpgradeSpecifier = ({
  fieldName,
  ruleUpgradeSpecifier,
  targetRuleType,
  globalPickVersion
}) => {
  var _ref, _fieldUpgradeSpecifie;
  if (!ruleUpgradeSpecifier.fields || Object.keys(ruleUpgradeSpecifier.fields).length === 0) {
    var _ruleUpgradeSpecifier;
    return {
      pick_version: (_ruleUpgradeSpecifier = ruleUpgradeSpecifier.pick_version) !== null && _ruleUpgradeSpecifier !== void 0 ? _ruleUpgradeSpecifier : globalPickVersion
    };
  }
  (0, _assert_diffable_fields_match_rule_type.assertDiffableFieldsMatchRuleType)(Object.keys(ruleUpgradeSpecifier.fields), targetRuleType);
  const fieldsToUpgradePayload = ruleUpgradeSpecifier.fields;
  const fieldGroup = (0, _diffable_rule_fields_mappings.mapRuleFieldToDiffableRuleField)({
    ruleType: targetRuleType,
    fieldName
  });
  const fieldUpgradeSpecifier = fieldsToUpgradePayload[fieldGroup];
  if ((fieldUpgradeSpecifier === null || fieldUpgradeSpecifier === void 0 ? void 0 : fieldUpgradeSpecifier.pick_version) === 'RESOLVED') {
    return {
      pick_version: 'RESOLVED',
      resolved_value: fieldUpgradeSpecifier.resolved_value
    };
  }
  return {
    pick_version: // If there's no matching specific field upgrade specifier in the payload,
    // we fallback to a rule level pick_version. Since this is also optional,
    // we default to the global pick_version.
    (_ref = (_fieldUpgradeSpecifie = fieldUpgradeSpecifier === null || fieldUpgradeSpecifier === void 0 ? void 0 : fieldUpgradeSpecifier.pick_version) !== null && _fieldUpgradeSpecifie !== void 0 ? _fieldUpgradeSpecifie : ruleUpgradeSpecifier.pick_version) !== null && _ref !== void 0 ? _ref : globalPickVersion
  };
};
exports.createFieldUpgradeSpecifier = createFieldUpgradeSpecifier;