"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GET_PAGE_FILTER_STORAGE_KEY = void 0;
exports.migrateAlertPageControlsTo816 = migrateAlertPageControlsTo816;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GET_PAGE_FILTER_STORAGE_KEY = (spaceId = 'default') => `siem.${spaceId}.pageFilters`;
exports.GET_PAGE_FILTER_STORAGE_KEY = GET_PAGE_FILTER_STORAGE_KEY;
/**
 * Ref PR : https://github.com/elastic/kibana/pull/190561
 *
 * The above PR breaks the local storage format of page filters controls.
 * This migration script is to migrate the old format to the new format.
 *
 */
async function migrateAlertPageControlsTo816(storage, plugins) {
  var _plugins$spaces, _space$id;
  const space = await ((_plugins$spaces = plugins.spaces) === null || _plugins$spaces === void 0 ? void 0 : _plugins$spaces.getActiveSpace());
  const spaceId = (_space$id = space === null || space === void 0 ? void 0 : space.id) !== null && _space$id !== void 0 ? _space$id : 'default';
  const storageKey = GET_PAGE_FILTER_STORAGE_KEY(spaceId);
  const oldFormat = storage.get(GET_PAGE_FILTER_STORAGE_KEY(spaceId));
  if (oldFormat && Object.keys(oldFormat).includes('panels')) {
    var _oldFormat$showApplyS;
    // Only run when it is old format
    const newFormat = {
      initialChildControlState: {},
      labelPosition: oldFormat.controlStyle,
      chainingSystem: oldFormat.chainingSystem,
      autoApplySelections: (_oldFormat$showApplyS = oldFormat.showApplySelections) !== null && _oldFormat$showApplyS !== void 0 ? _oldFormat$showApplyS : true,
      ignoreParentSettings: oldFormat.ignoreParentSettings,
      editorConfig: {
        hideWidthSettings: true,
        hideDataViewSelector: true,
        hideAdditionalSettings: true
      }
    };
    for (const [key, value] of Object.entries(oldFormat.panels)) {
      var _value$explicitInput$, _value$explicitInput$2, _value$explicitInput$3, _value$explicitInput$4;
      newFormat.initialChildControlState[key] = {
        type: 'optionsListControl',
        order: value.order,
        hideExclude: (_value$explicitInput$ = value.explicitInput.hideExclude) !== null && _value$explicitInput$ !== void 0 ? _value$explicitInput$ : true,
        hideSort: (_value$explicitInput$2 = value.explicitInput.hideSort) !== null && _value$explicitInput$2 !== void 0 ? _value$explicitInput$2 : true,
        placeholder: (_value$explicitInput$3 = value.explicitInput.placeholder) !== null && _value$explicitInput$3 !== void 0 ? _value$explicitInput$3 : '',
        width: value.width,
        dataViewId: (_value$explicitInput$4 = value.explicitInput.dataViewId) !== null && _value$explicitInput$4 !== void 0 ? _value$explicitInput$4 : 'security_solution_alerts_dv',
        title: value.explicitInput.title,
        fieldName: value.explicitInput.fieldName,
        selectedOptions: value.explicitInput.selectedOptions,
        hideActionBar: value.explicitInput.hideActionBar,
        persist: value.explicitInput.persist,
        hideExists: value.explicitInput.hideExists
      };
    }
    storage.set(storageKey, newFormat);
  }
}