"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEARCH_KQL_TOOLTIP = exports.SEARCH_KQL_SELECTED_TEXT = exports.SEARCH_KQL_PLACEHOLDER = exports.SEARCH_DESCRIPTION = exports.FILTER_KQL_TOOLTIP = exports.FILTER_KQL_SELECTED_TEXT = exports.FILTER_KQL_PLACEHOLDER = exports.FILTER_DESCRIPTION = exports.ERROR_PROCESSING_INDEX_PATTERNS = exports.DATA_PROVIDER_VISIBLE = exports.DATA_PROVIDER_HIDDEN_POPULATED = exports.DATA_PROVIDER_HIDDEN_EMPTY = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTER_DESCRIPTION = exports.FILTER_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.filterDescription', {
  defaultMessage: 'Events from the data providers above are filtered by the adjacent KQL'
});
const FILTER_KQL_TOOLTIP = exports.FILTER_KQL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.filterKqlTooltip', {
  defaultMessage: 'Events from the data providers above are filtered by this KQL'
});
const FILTER_KQL_PLACEHOLDER = exports.FILTER_KQL_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.filterKqlPlaceholder', {
  defaultMessage: 'Filter events'
});
const FILTER_KQL_SELECTED_TEXT = exports.FILTER_KQL_SELECTED_TEXT = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.filterKqlSelectedText', {
  defaultMessage: 'Filter'
});
const SEARCH_DESCRIPTION = exports.SEARCH_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.searchDescription', {
  defaultMessage: 'Events from the data providers above are combined with results from the adjacent KQL'
});
const SEARCH_KQL_TOOLTIP = exports.SEARCH_KQL_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.searchKqlTooltip', {
  defaultMessage: 'Events from the data providers above are combined with results from this KQL'
});
const SEARCH_KQL_PLACEHOLDER = exports.SEARCH_KQL_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.searchKqlPlaceholder', {
  defaultMessage: 'Search events'
});
const SEARCH_KQL_SELECTED_TEXT = exports.SEARCH_KQL_SELECTED_TEXT = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.searchKqlSelectedText', {
  defaultMessage: 'Search'
});
const DATA_PROVIDER_HIDDEN_POPULATED = exports.DATA_PROVIDER_HIDDEN_POPULATED = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.dataProviderToggle.hiddenAndPopulated', {
  defaultMessage: 'Click to access the query in the query builder'
});
const DATA_PROVIDER_VISIBLE = exports.DATA_PROVIDER_VISIBLE = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.dataProviderToggle.visible', {
  defaultMessage: 'Click to collapse the query builder'
});
const DATA_PROVIDER_HIDDEN_EMPTY = exports.DATA_PROVIDER_HIDDEN_EMPTY = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.dataProviderToggle.hiddenAndEmpty', {
  defaultMessage: 'Click to expand the empty query builder'
});
const ERROR_PROCESSING_INDEX_PATTERNS = exports.ERROR_PROCESSING_INDEX_PATTERNS = _i18n.i18n.translate('xpack.securitySolution.timeline.searchOrFilter.errorProcessingDataView', {
  defaultMessage: 'Error processing Index Patterns'
});