"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointNotice = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/constants");
var _routing = require("../../../management/common/routing");
var _use_navigate_to_app_event_handler = require("../../../common/hooks/endpoint/use_navigate_to_app_event_handler");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointNotice = exports.EndpointNotice = /*#__PURE__*/(0, _react.memo)(({
  onDismiss
}) => {
  const {
    getUrlForApp
  } = (0, _kibana.useKibana)().services.application;
  const endpointsPath = (0, _routing.getEndpointListPath)({
    name: 'endpointList'
  });
  const endpointsLink = getUrlForApp(_constants.APP_UI_ID, {
    path: endpointsPath
  });
  const handleGetStartedClick = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)(_constants.APP_UI_ID, {
    path: endpointsPath
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "endpoint-prompt-banner",
    iconType: "cheer",
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endpointNotice.introducing",
      defaultMessage: "Introducing: "
    })), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endpointNotice.title",
      defaultMessage: "Endpoint Security"
    }))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.endpointNotice.message",
    defaultMessage: "Protect your hosts with threat prevention, detection, and deep security data visibility."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleGetStartedClick,
    href: endpointsLink
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.endpointNotice.tryButton",
    defaultMessage: "Try Endpoint Security"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onDismiss
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.endpointNotice.dismiss",
    defaultMessage: "Dismiss message"
  }))));
});
EndpointNotice.displayName = 'EndpointNotice';