"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RULES_CARD_ITEMS_BY_ID = exports.RULES_CARD_ITEMS = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("./types");
var _types2 = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULES_CARD_ITEMS = exports.RULES_CARD_ITEMS = [{
  id: _types.RulesCardItemId.install,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.rulesCards.install.title', {
    defaultMessage: 'Install Elastic rules'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.onboarding.rulesCards.install.description', {
    defaultMessage: 'Quickly add and enable the rules you need with Elastic’s prebuilt rules'
  }),
  asset: {
    type: _types2.CardAssetType.video,
    source: '//play.vidyard.com/jpy1CcpBuowsA4a8t7gNDE',
    alt: _i18n.i18n.translate('xpack.securitySolution.onboarding.rulesCards.install.description', {
      defaultMessage: 'Quickly add and enable the rules you need with Elastic’s prebuilt rules'
    })
  }
}, {
  id: _types.RulesCardItemId.create,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.rulesCards.create.title', {
    defaultMessage: 'Create a custom rule'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.onboarding.rulesCards.create.description', {
    defaultMessage: 'Create a custom detection rule for local or remote data'
  }),
  asset: {
    type: _types2.CardAssetType.video,
    source: '//play.vidyard.com/2q7LSLrsC8qEFQUNHFu9zf',
    alt: _i18n.i18n.translate('xpack.securitySolution.onboarding.rulesCards.create.description', {
      defaultMessage: 'Create a custom detection rule for local or remote data'
    })
  }
}];
const RULES_CARD_ITEMS_BY_ID = exports.RULES_CARD_ITEMS_BY_ID = Object.fromEntries(RULES_CARD_ITEMS.map(card => [card.id, card]));