"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendKillProcessRequest = void 0;
var _reactQuery = require("@kbn/react-query");
var _process_actions = require("../../../common/lib/process_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Create kill process requests
 * @param customOptions
 */
const useSendKillProcessRequest = customOptions => {
  return (0, _reactQuery.useMutation)(processData => {
    return (0, _process_actions.killProcess)(processData);
  }, customOptions);
};
exports.useSendKillProcessRequest = useSendKillProcessRequest;