"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/session-view-plugin/public");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _session_view = require("../../left/components/session_view");
var _panel_keys = require("../../shared/constants/panel_keys");
var _constants = require("../../preview/constants");
var _context = require("../context");
var _model = require("../../../../sourcerer/store/model");
var _containers = require("../../../../sourcerer/containers");
var _use_selected_patterns = require("../../../../data_view_manager/hooks/use_selected_patterns");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Tab displayed in the SessionView preview panel, shows alerts related to the session.
 */
const AlertsTab = exports.AlertsTab = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    eventId,
    indexName,
    investigatedAlertId,
    sessionEntityId,
    sessionStartTime,
    scopeId
  } = (0, _context.useSessionViewPanelContext)();
  const {
    data: alertsData,
    fetchNextPage: fetchNextPageAlerts,
    isFetching: isFetchingAlerts,
    hasNextPage: hasNextPageAlerts
  } = (0, _public.useFetchSessionViewAlerts)(sessionEntityId, sessionStartTime, investigatedAlertId);
  const {
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.detections);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_model.SourcererScopeName.detections);
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const alertsIndex = (0, _react.useMemo)(() => selectedPatterns.join(','), [selectedPatterns]);

  // this code mimics what is being done in the x-pack/plugins/session_view/public/components/session_view/index.tsx file
  const alerts = (0, _react.useMemo)(() => {
    let events = [];
    if (alertsData) {
      alertsData.pages.forEach(page => {
        events = events.concat(page.events);
      });
    }
    return events;
  }, [alertsData]);
  const {
    openPreviewPanel,
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const openAlertDetailsPreview = (0, _react.useCallback)((evtId, onClose) => {
    openPreviewPanel({
      id: _panel_keys.DocumentDetailsPreviewPanelKey,
      params: {
        id: evtId,
        indexName: alertsIndex,
        scopeId,
        banner: _constants.ALERT_PREVIEW_BANNER,
        isPreviewMode: true
      }
    });
  }, [openPreviewPanel, scopeId, alertsIndex]);

  // this code mimics what is being done in the x-pack/plugins/session_view/public/components/session_view/index.tsx file
  const jumpToEvent = (0, _react.useCallback)(event => {
    let jumpToEntityId = null;
    let jumpToCursor = null;
    if (event.process) {
      const {
        entity_id: entityId
      } = event.process;
      if (entityId !== sessionEntityId) {
        var _event$kibana;
        const alert = (_event$kibana = event.kibana) === null || _event$kibana === void 0 ? void 0 : _event$kibana.alert;
        const cursor = alert ? alert === null || alert === void 0 ? void 0 : alert.original_time : event['@timestamp'];
        if (cursor) {
          jumpToEntityId = entityId;
          jumpToCursor = cursor;
        }
      }
    }
    openLeftPanel({
      id: _panel_keys.DocumentDetailsLeftPanelKey,
      params: {
        id: eventId,
        indexName,
        scopeId,
        jumpToEntityId,
        jumpToCursor
      },
      path: {
        tab: 'visualize',
        subTab: _session_view.SESSION_VIEW_ID
      }
    });
  }, [eventId, indexName, openLeftPanel, scopeId, sessionEntityId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none",
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.preview.sessionview.alertsContentAriaLabel', {
      defaultMessage: 'Process'
    })
  }, /*#__PURE__*/_react.default.createElement(_public.DetailPanelAlertTab, {
    alerts: alerts,
    isFetchingAlerts: isFetchingAlerts,
    hasNextPageAlerts: hasNextPageAlerts,
    fetchNextPageAlerts: fetchNextPageAlerts,
    onJumpToEvent: jumpToEvent,
    onShowAlertDetails: openAlertDetailsPreview,
    investigatedAlertId: investigatedAlertId
  }));
});
AlertsTab.displayName = 'AlertsTab';