"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuppressedAlerts = void 0;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _test_ids = require("./test_ids");
var _investigate_in_timeline_action = require("../../../../detections/components/alerts_table/timeline_actions/investigate_in_timeline_action");
var _utils = require("../../../../../common/detection_engine/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUPPRESSED_ALERTS_COUNT_TECHNICAL_PREVIEW = _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.suppressedAlertsCountTechnicalPreview', {
  defaultMessage: 'Technical Preview'
});
/**
 * Displays number of suppressed alerts and investigate in timeline icon
 */
const SuppressedAlerts = ({
  dataAsNestedObject,
  alertSuppressionCount,
  showInvestigateInTimeline
}) => {
  var _get;
  const ruleType = (_get = (0, _lodash.get)(dataAsNestedObject, _ruleDataUtils.ALERT_RULE_TYPE)) === null || _get === void 0 ? void 0 : _get[0];
  const title = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlations.suppressedAlertsTitle",
    defaultMessage: "{count} suppressed {count, plural, =1 {alert} other {alerts}}",
    values: {
      count: alertSuppressionCount
    }
  })), (0, _utils.isSuppressionRuleInGA)(ruleType) ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: SUPPRESSED_ALERTS_COUNT_TECHNICAL_PREVIEW,
    css: (0, _react2.css)`
              vertical-align: middle;
            `,
    size: "s",
    "data-test-subj": _test_ids.SUPPRESSED_ALERTS_SECTION_TECHNICAL_PREVIEW_TEST_ID
  })));
  const headerContent = alertSuppressionCount > 0 && showInvestigateInTimeline && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${_test_ids.CORRELATIONS_DETAILS_SUPPRESSED_ALERTS_SECTION_TEST_ID}InvestigateInTimeline`
  }, /*#__PURE__*/_react.default.createElement(_investigate_in_timeline_action.InvestigateInTimelineAction, {
    ecsRowData: dataAsNestedObject,
    buttonType: 'emptyButton'
  }));
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title,
      iconType: 'layers',
      headerContent
    },
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_SUPPRESSED_ALERTS_SECTION_TEST_ID
  });
};
exports.SuppressedAlerts = SuppressedAlerts;
SuppressedAlerts.displayName = 'SuppressedAlerts';