"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionView = exports.SESSION_VIEW_ID = exports.SESSION_VIEWER_BANNER = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _user_privileges = require("../../../../common/components/user_privileges");
var _test_ids = require("./test_ids");
var _containers = require("../../../../sourcerer/containers");
var _panel_keys = require("../../shared/constants/panel_keys");
var _kibana = require("../../../../common/lib/kibana");
var _context = require("../../shared/context");
var _model = require("../../../../sourcerer/store/model");
var _constants = require("../../preview/constants");
var _use_license = require("../../../../common/hooks/use_license");
var _use_session_view_config = require("../../shared/hooks/use_session_view_config");
var _session_view_no_data_message = require("../../shared/components/session_view_no_data_message");
var _telemetry = require("../../../../common/lib/telemetry");
var _use_selected_patterns = require("../../../../data_view_manager/hooks/use_selected_patterns");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SESSION_VIEW_ID = exports.SESSION_VIEW_ID = 'session-view';
const SESSION_VIEWER_BANNER = exports.SESSION_VIEWER_BANNER = {
  title: _i18n.i18n.translate('xpack.securitySolution.flyout.preview.sessionViewerTitle', {
    defaultMessage: 'Preview session view panel'
  }),
  backgroundColor: 'warning',
  textColor: 'warning'
};

/**
 * Session view displayed in the document details expandable flyout left section under the Visualize tab
 */
const SessionView = exports.SessionView = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    sessionView,
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    eventId,
    indexName,
    getFieldsData,
    scopeId,
    dataFormattedForFieldBrowser,
    jumpToEntityId,
    jumpToCursor
  } = (0, _context.useDocumentDetailsContext)();
  const {
    canReadPolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const sessionViewConfig = (0, _use_session_view_config.useSessionViewConfig)({
    getFieldsData,
    dataFormattedForFieldBrowser
  });
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const isEnabled = sessionViewConfig && isEnterprisePlus;
  const {
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.detections);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_model.SourcererScopeName.detections);
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const alertsIndex = (0, _react.useMemo)(() => selectedPatterns.join(','), [selectedPatterns]);
  const {
    openPreviewPanel,
    closePreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const openAlertDetailsPreview = (0, _react.useCallback)((evtId, onClose) => {
    // In the SessionView component, when the user clicks on the
    // expand button to open a alert in the preview panel, this actually also selects the row and opens
    // the detailed panel in preview.
    // In order to NOT modify the SessionView code, the setTimeout here guarantees that the alert details preview
    // will be opened in second, so that we have a correct order in the opened preview panels
    setTimeout(() => {
      openPreviewPanel({
        id: _panel_keys.DocumentDetailsPreviewPanelKey,
        params: {
          id: evtId,
          indexName: alertsIndex,
          scopeId,
          banner: _constants.ALERT_PREVIEW_BANNER,
          isPreviewMode: true
        }
      });
    }, 100);
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: scopeId,
      panel: 'preview'
    });
  }, [openPreviewPanel, alertsIndex, scopeId, telemetry]);
  const openDetailsInPreview = (0, _react.useCallback)(selectedProcess => {
    // We cannot pass the original Process object sent from the SessionView component
    // as it contains functions (that should not put into Redux)
    // and also some recursive properties (that will break rison.encode when updating the URL)
    const simplifiedSelectedProcess = selectedProcess ? {
      id: selectedProcess.id,
      details: selectedProcess.getDetails(),
      endTime: selectedProcess.getEndTime()
    } : null;
    openPreviewPanel({
      id: _panel_keys.DocumentDetailsSessionViewPanelKey,
      params: {
        eventId,
        indexName,
        selectedProcess: simplifiedSelectedProcess,
        index: sessionViewConfig === null || sessionViewConfig === void 0 ? void 0 : sessionViewConfig.index,
        sessionEntityId: sessionViewConfig === null || sessionViewConfig === void 0 ? void 0 : sessionViewConfig.sessionEntityId,
        sessionStartTime: sessionViewConfig === null || sessionViewConfig === void 0 ? void 0 : sessionViewConfig.sessionStartTime,
        investigatedAlertId: sessionViewConfig === null || sessionViewConfig === void 0 ? void 0 : sessionViewConfig.investigatedAlertId,
        scopeId,
        jumpToEntityId,
        jumpToCursor,
        banner: SESSION_VIEWER_BANNER
      }
    });
  }, [openPreviewPanel, eventId, indexName, sessionViewConfig === null || sessionViewConfig === void 0 ? void 0 : sessionViewConfig.index, sessionViewConfig === null || sessionViewConfig === void 0 ? void 0 : sessionViewConfig.sessionEntityId, sessionViewConfig === null || sessionViewConfig === void 0 ? void 0 : sessionViewConfig.sessionStartTime, sessionViewConfig === null || sessionViewConfig === void 0 ? void 0 : sessionViewConfig.investigatedAlertId, scopeId, jumpToEntityId, jumpToCursor]);
  const closeDetailsInPreview = (0, _react.useCallback)(() => closePreviewPanel(), [closePreviewPanel]);
  return isEnabled ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.SESSION_VIEW_TEST_ID
  }, sessionView.getSessionView({
    ...sessionViewConfig,
    isFullScreen: true,
    loadAlertDetails: openAlertDetailsPreview,
    openDetailsInExpandableFlyout: selectedProcess => openDetailsInPreview(selectedProcess),
    closeDetailsInExpandableFlyout: () => closeDetailsInPreview(),
    canReadPolicyManagement,
    resetJumpToEntityId: jumpToEntityId,
    resetJumpToCursor: jumpToCursor
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_session_view_no_data_message.SessionViewNoDataMessage, {
    isEnterprisePlus: isEnterprisePlus,
    hasSessionViewConfig: sessionViewConfig !== null
  }));
});
SessionView.displayName = 'SessionView';