"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_RISK_SCORES_ENABLED_TITLE = exports.UNINSTALLATION_ERROR = exports.TRANSFORM_DELETION_ERROR_MESSAGE = exports.TRANSFORM_CREATION_ERROR_MESSAGE = exports.STORED_SCRIPT_DELETION_ERROR_MESSAGE = exports.STORED_SCRIPT_CREATION_ERROR_MESSAGE = exports.STOP_TRANSFORMS_ERROR_MESSAGE = exports.START_TRANSFORMS_ERROR_MESSAGE = exports.RISK_SCORES_ENABLED_TEXT = exports.INSTALLATION_ERROR = exports.INGEST_PIPELINE_DELETION_ERROR_MESSAGE = exports.INGEST_PIPELINE_CREATION_ERROR_MESSAGE = exports.IMPORT_SAVED_OBJECTS_SUCCESS = exports.IMPORT_SAVED_OBJECTS_FAILURE = exports.HOST_RISK_SCORES_ENABLED_TITLE = exports.GET_TRANSFORM_STATE_NOT_FOUND_MESSAGE = exports.GET_TRANSFORM_STATE_ERROR_MESSAGE = exports.DELETE_SAVED_OBJECTS_FAILURE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INGEST_PIPELINE_CREATION_ERROR_MESSAGE = exports.INGEST_PIPELINE_CREATION_ERROR_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.riskScore.api.ingestPipeline.create.errorMessageTitle', {
  defaultMessage: 'Failed to create Ingest pipeline'
});
const INGEST_PIPELINE_DELETION_ERROR_MESSAGE = totalCount => _i18n.i18n.translate('xpack.securitySolution.riskScore.api.ingestPipeline.delete.errorMessageTitle', {
  values: {
    totalCount
  },
  defaultMessage: `Failed to delete Ingest {totalCount, plural, =1 {pipeline} other {pipelines}}`
});
exports.INGEST_PIPELINE_DELETION_ERROR_MESSAGE = INGEST_PIPELINE_DELETION_ERROR_MESSAGE;
const STORED_SCRIPT_CREATION_ERROR_MESSAGE = exports.STORED_SCRIPT_CREATION_ERROR_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.riskScore.api.storedScript.create.errorMessageTitle', {
  defaultMessage: 'Failed to create stored script'
});
const STORED_SCRIPT_DELETION_ERROR_MESSAGE = exports.STORED_SCRIPT_DELETION_ERROR_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.riskScore.api.storedScript.delete.errorMessageTitle', {
  defaultMessage: `Failed to delete stored script`
});
const TRANSFORM_CREATION_ERROR_MESSAGE = exports.TRANSFORM_CREATION_ERROR_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.riskScore.api.transforms.create.errorMessageTitle', {
  defaultMessage: 'Failed to create Transform'
});
const TRANSFORM_DELETION_ERROR_MESSAGE = totalCount => _i18n.i18n.translate('xpack.securitySolution.riskScore.api.transforms.delete.errorMessageTitle', {
  values: {
    totalCount
  },
  defaultMessage: `Failed to delete {totalCount, plural, =1 {Transform} other {Transforms}}`
});
exports.TRANSFORM_DELETION_ERROR_MESSAGE = TRANSFORM_DELETION_ERROR_MESSAGE;
const GET_TRANSFORM_STATE_ERROR_MESSAGE = exports.GET_TRANSFORM_STATE_ERROR_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.riskScore.api.transforms.getState.errorMessageTitle', {
  defaultMessage: `Failed to get Transform state`
});
const GET_TRANSFORM_STATE_NOT_FOUND_MESSAGE = exports.GET_TRANSFORM_STATE_NOT_FOUND_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.riskScore.api.transforms.getState.notFoundMessageTitle', {
  defaultMessage: `Transform not found`
});
const START_TRANSFORMS_ERROR_MESSAGE = totalCount => _i18n.i18n.translate('xpack.securitySolution.riskScore.api.transforms.start.errorMessageTitle', {
  values: {
    totalCount
  },
  defaultMessage: `Failed to start {totalCount, plural, =1 {Transform} other {Transforms}}`
});
exports.START_TRANSFORMS_ERROR_MESSAGE = START_TRANSFORMS_ERROR_MESSAGE;
const STOP_TRANSFORMS_ERROR_MESSAGE = totalCount => _i18n.i18n.translate('xpack.securitySolution.riskScore.api.transforms.stop.errorMessageTitle', {
  values: {
    totalCount
  },
  defaultMessage: `Failed to stop {totalCount, plural, =1 {Transform} other {Transforms}}`
});
exports.STOP_TRANSFORMS_ERROR_MESSAGE = STOP_TRANSFORMS_ERROR_MESSAGE;
const INSTALLATION_ERROR = exports.INSTALLATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.riskScore.install.errorMessageTitle', {
  defaultMessage: 'Installation error'
});
const UNINSTALLATION_ERROR = exports.UNINSTALLATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.riskScore.uninstall.errorMessageTitle', {
  defaultMessage: 'Uninstallation error'
});
const IMPORT_SAVED_OBJECTS_SUCCESS = totalCount => _i18n.i18n.translate('xpack.securitySolution.riskScore.savedObjects.bulkCreateSuccessTitle', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount} {totalCount, plural, =1 {saved object} other {saved objects}} imported successfully`
});
exports.IMPORT_SAVED_OBJECTS_SUCCESS = IMPORT_SAVED_OBJECTS_SUCCESS;
const IMPORT_SAVED_OBJECTS_FAILURE = exports.IMPORT_SAVED_OBJECTS_FAILURE = _i18n.i18n.translate('xpack.securitySolution.riskScore.savedObjects.bulkCreateFailureTitle', {
  defaultMessage: `Failed to import saved objects`
});
const DELETE_SAVED_OBJECTS_FAILURE = exports.DELETE_SAVED_OBJECTS_FAILURE = _i18n.i18n.translate('xpack.securitySolution.riskScore.savedObjects.bulkDeleteFailureTitle', {
  defaultMessage: `Failed to delete saved objects`
});
const HOST_RISK_SCORES_ENABLED_TITLE = exports.HOST_RISK_SCORES_ENABLED_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.hostRiskScoresEnabledTitle', {
  defaultMessage: `Host Risk Scores enabled`
});
const USER_RISK_SCORES_ENABLED_TITLE = exports.USER_RISK_SCORES_ENABLED_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.userRiskScoresEnabledTitle', {
  defaultMessage: `User Risk Scores enabled`
});
const RISK_SCORES_ENABLED_TEXT = items => _i18n.i18n.translate('xpack.securitySolution.riskScore.savedObjects.enableRiskScoreSuccessTitle', {
  values: {
    items
  },
  defaultMessage: `{items} imported successfully`
});
exports.RISK_SCORES_ENABLED_TEXT = RISK_SCORES_ENABLED_TEXT;