"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upgradeUserRiskScoreModule = exports.upgradeHostRiskScoreModule = exports.uninstallRiskScoreModule = exports.restartRiskScoreTransforms = exports.installRiskScoreModule = void 0;
var _search_strategy = require("../../../../common/search_strategy");
var utils = _interopRequireWildcard(require("../../../../common/utils/risk_score_modules"));
var _api = require("../../deprecated_risk_engine/api");
var _translations = require("../../deprecated_risk_engine/api/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const installHostRiskScoreModule = async ({
  share,
  http,
  refetch,
  renderDashboardLink,
  renderDocLink,
  timerange,
  startServices
}) => {
  await (0, _api.installRiskScore)({
    http,
    renderDocLink,
    options: {
      riskScoreEntity: _search_strategy.EntityType.host
    },
    startServices
  });

  // Install dashboards and relevant saved objects
  await (0, _api.bulkCreatePrebuiltSavedObjects)({
    http,
    share,
    renderDashboardLink,
    renderDocLink,
    ...timerange,
    options: {
      templateName: `${_search_strategy.EntityType.host}RiskScoreDashboards`
    },
    startServices
  });
  if (refetch) {
    refetch();
  }
};
const installUserRiskScoreModule = async ({
  share,
  http,
  refetch,
  renderDashboardLink,
  renderDocLink,
  spaceId = 'default',
  timerange,
  startServices
}) => {
  await (0, _api.installRiskScore)({
    http,
    renderDocLink,
    options: {
      riskScoreEntity: _search_strategy.EntityType.user
    },
    startServices
  });

  // Install dashboards and relevant saved objects
  await (0, _api.bulkCreatePrebuiltSavedObjects)({
    share,
    http,
    options: {
      templateName: `${_search_strategy.EntityType.user}RiskScoreDashboards`
    },
    renderDashboardLink,
    renderDocLink,
    startServices,
    ...timerange
  });
  if (refetch) {
    refetch();
  }
};
const installRiskScoreModule = async settings => {
  if (settings.riskScoreEntity === _search_strategy.EntityType.user) {
    await installUserRiskScoreModule(settings);
  } else {
    await installHostRiskScoreModule(settings);
  }
};
exports.installRiskScoreModule = installRiskScoreModule;
const uninstallRiskScoreModule = async ({
  http,
  refetch,
  renderDocLink,
  riskScoreEntity,
  spaceId = 'default',
  startServices
}) => {
  const legacyTransformIds = [
  // transform Ids never changed since 8.3
  utils.getRiskScorePivotTransformId(riskScoreEntity, spaceId), utils.getRiskScoreLatestTransformId(riskScoreEntity, spaceId)];
  const legacyRiskScoreHostsScriptIds = [
  // 8.4
  utils.getLegacyRiskScoreLevelScriptId(_search_strategy.EntityType.host), utils.getLegacyRiskScoreInitScriptId(_search_strategy.EntityType.host), utils.getLegacyRiskScoreMapScriptId(_search_strategy.EntityType.host), utils.getLegacyRiskScoreReduceScriptId(_search_strategy.EntityType.host),
  // 8.3 and after 8.5
  utils.getRiskScoreLevelScriptId(_search_strategy.EntityType.host, spaceId), utils.getRiskScoreInitScriptId(_search_strategy.EntityType.host, spaceId), utils.getRiskScoreMapScriptId(_search_strategy.EntityType.host, spaceId), utils.getRiskScoreReduceScriptId(_search_strategy.EntityType.host, spaceId)];
  const legacyRiskScoreUsersScriptIds = [
  // 8.4
  utils.getLegacyRiskScoreLevelScriptId(_search_strategy.EntityType.user), utils.getLegacyRiskScoreMapScriptId(_search_strategy.EntityType.user), utils.getLegacyRiskScoreReduceScriptId(_search_strategy.EntityType.user),
  // 8.3 and after 8.5
  utils.getRiskScoreLevelScriptId(_search_strategy.EntityType.user, spaceId), utils.getRiskScoreMapScriptId(_search_strategy.EntityType.user, spaceId), utils.getRiskScoreReduceScriptId(_search_strategy.EntityType.user, spaceId)];
  const legacyIngestPipelineNames = [
  // 8.4
  utils.getLegacyIngestPipelineName(riskScoreEntity),
  // 8.3 and 8.5
  utils.getIngestPipelineName(riskScoreEntity, spaceId)];
  await Promise.all([
  /**
   * Intended not to pass notification to bulkDeletePrebuiltSavedObjects.
   * As the only error it can happen is saved object not found, and
   * that is what bulkDeletePrebuiltSavedObjects wants.
   * (Before 8.5 once an saved object was created, it was shared across different spaces.
   * If it has been upgrade in one space, "saved object not found" will happen when upgrading other spaces.
   * Or it could be users manually deleted the saved object.)
   */
  (0, _api.bulkDeletePrebuiltSavedObjects)({
    http,
    options: {
      templateName: `${riskScoreEntity}RiskScoreDashboards`
    },
    startServices
  }), (0, _api.deleteTransforms)({
    http,
    renderDocLink,
    errorMessage: `${_translations.UNINSTALLATION_ERROR} - ${(0, _translations.TRANSFORM_DELETION_ERROR_MESSAGE)(legacyTransformIds.length)}`,
    transformIds: legacyTransformIds,
    options: {
      deleteDestIndex: true,
      deleteDestDataView: true,
      forceDelete: false
    },
    startServices
  }),
  /**
   * Intended not to pass notification to deleteIngestPipelines.
   * As the only error it can happen is ingest pipeline not found, and
   * that is what deleteIngestPipelines wants.
   * (Before 8.5 once an ingest pipeline was created, it was shared across different spaces.
   * If it has been upgrade in one space, "ingest pipeline not found" will happen when upgrading other spaces.
   * Or it could be users manually deleted the ingest pipeline.)
   */
  (0, _api.deleteIngestPipelines)({
    http,
    errorMessage: `${_translations.UNINSTALLATION_ERROR} - ${(0, _translations.INGEST_PIPELINE_DELETION_ERROR_MESSAGE)(legacyIngestPipelineNames.length)}`,
    names: legacyIngestPipelineNames.join(','),
    startServices
  }),
  /**
   * Intended not to pass notification to deleteStoredScripts.
   * As the only error it can happen is script not found, and
   * that is what deleteStoredScripts wants.
   * (In 8.4 once a script was created, it was shared across different spaces.
   * If it has been upgrade in one space, "script not found" will happen when upgrading other spaces.
   * Or it could be users manually deleted the script.)
   */
  (0, _api.deleteStoredScripts)({
    http,
    ids: riskScoreEntity === _search_strategy.EntityType.user ? legacyRiskScoreUsersScriptIds : legacyRiskScoreHostsScriptIds,
    startServices
  })]);
  if (refetch) {
    refetch();
  }
};
exports.uninstallRiskScoreModule = uninstallRiskScoreModule;
const upgradeHostRiskScoreModule = async ({
  share,
  http,
  refetch,
  renderDashboardLink,
  renderDocLink,
  spaceId = 'default',
  timerange,
  startServices
}) => {
  await uninstallRiskScoreModule({
    http,
    renderDocLink,
    riskScoreEntity: _search_strategy.EntityType.host,
    spaceId,
    startServices
  });
  await installRiskScoreModule({
    share,
    http,
    refetch,
    renderDashboardLink,
    renderDocLink,
    riskScoreEntity: _search_strategy.EntityType.host,
    spaceId,
    timerange,
    startServices
  });
};
exports.upgradeHostRiskScoreModule = upgradeHostRiskScoreModule;
const upgradeUserRiskScoreModule = async ({
  share,
  http,
  refetch,
  renderDashboardLink,
  renderDocLink,
  spaceId = 'default',
  timerange,
  startServices
}) => {
  await uninstallRiskScoreModule({
    http,
    renderDocLink,
    riskScoreEntity: _search_strategy.EntityType.user,
    spaceId,
    startServices
  });
  await installRiskScoreModule({
    share,
    http,
    refetch,
    renderDashboardLink,
    renderDocLink,
    riskScoreEntity: _search_strategy.EntityType.user,
    spaceId,
    timerange,
    startServices
  });
};
exports.upgradeUserRiskScoreModule = upgradeUserRiskScoreModule;
const restartRiskScoreTransforms = async ({
  http,
  refetch,
  renderDocLink,
  riskScoreEntity,
  spaceId,
  startServices
}) => {
  const transformIds = [utils.getRiskScorePivotTransformId(riskScoreEntity, spaceId), utils.getRiskScoreLatestTransformId(riskScoreEntity, spaceId)];
  await (0, _api.stopTransforms)({
    http,
    renderDocLink,
    transformIds,
    startServices
  });
  const res = await (0, _api.startTransforms)({
    http,
    renderDocLink,
    transformIds,
    startServices
  });
  if (refetch) {
    refetch();
  }
  return res;
};
exports.restartRiskScoreTransforms = restartRiskScoreTransforms;