"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityStoreDashboardPanels = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_enabled_entity_types = require("../../../hooks/use_enabled_entity_types");
var _entity_analytics = require("../../../../../common/api/entity_analytics");
var _entities_list = require("../entities_list");
var _use_entity_store = require("../hooks/use_entity_store");
var _entity_analytics_risk_score = require("../../entity_analytics_risk_score");
var _use_risk_engine_status = require("../../../api/hooks/use_risk_engine_status");
var _dashboard_enablement_panel = require("./dashboard_enablement_panel");
var _entity_store_error_callout = require("./entity_store_error_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityStoreDashboardPanelsComponent = () => {
  var _storeStatusQuery$dat, _storeStatusQuery$dat2, _riskEngineStatus$dat, _riskEngineStatus$dat2, _storeStatusQuery$dat3, _storeStatusQuery$dat4;
  const riskEngineStatus = (0, _use_risk_engine_status.useRiskEngineStatus)();
  const storeStatusQuery = (0, _use_entity_store.useEntityStoreStatus)({});
  const entityTypes = (0, _use_enabled_entity_types.useStoreEntityTypes)();
  const callouts = ((_storeStatusQuery$dat = (_storeStatusQuery$dat2 = storeStatusQuery.data) === null || _storeStatusQuery$dat2 === void 0 ? void 0 : _storeStatusQuery$dat2.engines) !== null && _storeStatusQuery$dat !== void 0 ? _storeStatusQuery$dat : []).filter(engine => engine.status === 'error').map(engine => /*#__PURE__*/_react.default.createElement(_entity_store_error_callout.EntityStoreErrorCallout, {
    engine: engine
  }));
  if (storeStatusQuery.status === 'loading') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl"
      })
    }));
  }
  const atLeastOneRiskEngineInstalled = ((_riskEngineStatus$dat = riskEngineStatus.data) === null || _riskEngineStatus$dat === void 0 ? void 0 : _riskEngineStatus$dat.risk_engine_status) !== _entity_analytics.RiskEngineStatusEnum.NOT_INSTALLED || ((_riskEngineStatus$dat2 = riskEngineStatus.data) === null || _riskEngineStatus$dat2 === void 0 ? void 0 : _riskEngineStatus$dat2.legacy_risk_engine_status) !== _entity_analytics.RiskEngineStatusEnum.NOT_INSTALLED;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "entityStorePanelsGroup"
  }, storeStatusQuery.status === 'error' ? callouts : /*#__PURE__*/_react.default.createElement(_dashboard_enablement_panel.EnablementPanel, {
    state: {
      riskEngine: riskEngineStatus,
      entityStore: storeStatusQuery
    }
  }), atLeastOneRiskEngineInstalled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, entityTypes.map(entityType => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: entityType
  }, /*#__PURE__*/_react.default.createElement(_entity_analytics_risk_score.EntityAnalyticsRiskScores, {
    riskEntity: entityType
  })))), ((_storeStatusQuery$dat3 = storeStatusQuery.data) === null || _storeStatusQuery$dat3 === void 0 ? void 0 : _storeStatusQuery$dat3.status) !== 'not_installed' && ((_storeStatusQuery$dat4 = storeStatusQuery.data) === null || _storeStatusQuery$dat4 === void 0 ? void 0 : _storeStatusQuery$dat4.status) !== 'installing' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "entitiesListPanel"
  }, /*#__PURE__*/_react.default.createElement(_entities_list.EntitiesList, null)));
};
const EntityStoreDashboardPanels = exports.EntityStoreDashboardPanels = /*#__PURE__*/_react.default.memo(EntityStoreDashboardPanelsComponent);
EntityStoreDashboardPanels.displayName = 'EntityStoreDashboardPanels';