"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCellActionsOptions = void 0;
var _react = require("react");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _cell_actions = require("../../../common/components/cell_actions");
var _constants = require("../../../app/actions/constants");
var _model = require("../../../sourcerer/store/model");
var _use_get_field_spec = require("../../../common/hooks/use_get_field_spec");
var _use_data_view_id = require("../../../common/hooks/use_data_view_id");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCellActionsOptions = (tableId, context) => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.detections);
  const {
    columns = [],
    oldAlertsData: data = [],
    pageIndex = 0,
    pageSize = 0,
    dataGridRef
  } = context !== null && context !== void 0 ? context : {};
  const oldGetFieldSpec = (0, _use_get_field_spec.useGetFieldSpec)(_model.SourcererScopeName.detections);
  const oldDataViewId = (0, _use_data_view_id.useDataViewId)(_model.SourcererScopeName.detections);
  const dataViewId = newDataViewPickerEnabled ? experimentalDataView.id : oldDataViewId;
  const cellActionsMetadata = (0, _react.useMemo)(() => ({
    scopeId: tableId,
    dataViewId
  }), [dataViewId, tableId]);
  const cellActionsFields = (0, _react.useMemo)(() => columns.map(column => {
    var _ref, _experimentalDataView, _experimentalDataView2;
    return (_ref = newDataViewPickerEnabled ? (_experimentalDataView = experimentalDataView.fields) === null || _experimentalDataView === void 0 ? void 0 : (_experimentalDataView2 = _experimentalDataView.getByName(column.id)) === null || _experimentalDataView2 === void 0 ? void 0 : _experimentalDataView2.toSpec() : oldGetFieldSpec(column.id)) !== null && _ref !== void 0 ? _ref : {
      name: '',
      type: '',
      // When type is an empty string all cell actions are incompatible
      aggregatable: false,
      searchable: false
    };
  }), [columns, experimentalDataView.fields, oldGetFieldSpec, newDataViewPickerEnabled]);

  /**
   * There is difference between how `triggers actions` fetched data v/s
   * how security solution fetches data via timelineSearchStrategy
   *
   * _id and _index fields are array in timelineSearchStrategy  but not in
   * ruleStrategy
   *
   *
   */

  const finalData = (0, _react.useMemo)(() => data.map(row => row.map(field => {
    let localField = field;
    if (['_id', '_index'].includes(field.field)) {
      var _field$value;
      const newValue = (_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : '';
      localField = {
        field: field.field,
        value: Array.isArray(newValue) ? newValue : [newValue]
      };
    }
    return localField;
  })), [data]);
  const getCellValue = (0, _react.useCallback)((fieldName, rowIndex) => {
    var _finalData$pageRowInd, _finalData$pageRowInd2, _finalData$pageRowInd3;
    const pageRowIndex = rowIndex - pageSize * pageIndex;
    return (_finalData$pageRowInd = (_finalData$pageRowInd2 = finalData[pageRowIndex]) === null || _finalData$pageRowInd2 === void 0 ? void 0 : (_finalData$pageRowInd3 = _finalData$pageRowInd2.find(rowData => rowData.field === fieldName)) === null || _finalData$pageRowInd3 === void 0 ? void 0 : _finalData$pageRowInd3.value) !== null && _finalData$pageRowInd !== void 0 ? _finalData$pageRowInd : [];
  }, [finalData, pageIndex, pageSize]);
  const disabledActionTypes = tableId === _securitysolutionDataTable.TableId.alertsOnCasePage ? [_constants.SecurityCellActionType.FILTER] : undefined;
  const cellActions = (0, _cell_actions.useDataGridColumnsSecurityCellActions)({
    triggerId: _constants.SecurityCellActionsTrigger.DEFAULT,
    fields: cellActionsFields,
    getCellValue,
    metadata: cellActionsMetadata,
    dataGridRef,
    disabledActionTypes
  });
  return (0, _react.useMemo)(() => {
    return {
      getCellActionsForColumn: (_columnId, columnIndex) => {
        if (cellActions.length === 0) return [];
        return cellActions[columnIndex];
      },
      visibleCellActions: 3
    };
  }, [cellActions]);
};
exports.useCellActionsOptions = useCellActionsOptions;