"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useParentLinks = exports.useNormalizedAppLinks = exports.useNavLinkExists = exports.useLinkInfo = exports.useLinkAuthorized = exports.useGetLinkInfo = void 0;
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _links = require("@kbn/security-solution-navigation/links");
var _application_links_updater = require("../../app/links/application_links_updater");
var _kibana_react = require("../lib/kibana/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to get the normalized app links updated value
 */
const useNormalizedAppLinks = () => (0, _useObservable.default)(_application_links_updater.applicationLinksUpdater.normalizedLinks$, _application_links_updater.applicationLinksUpdater.getNormalizedLinksValue());

/**
 * Hook to check if a link is registered in the nav links (plugin deepLinks)
 * A link is only registered if authorized and exists in the navigationTree hierarchy.
 * Warning: this hook does not update the value when the navLinks change. It should not be a problem
 * since the deepLinks are only updated during the plugin lifecycle or license changes, which require a page reload.
 */
exports.useNormalizedAppLinks = useNormalizedAppLinks;
const useNavLinkExists = id => {
  const {
    navLinks
  } = (0, _kibana_react.useKibana)().services.chrome;
  const navLinkExists = (0, _react.useMemo)(() => navLinks.has((0, _links.securityLink)(id)), [navLinks, id]);
  return navLinkExists;
};

/**
 * Hook to get the link info from the application links.
 */
exports.useNavLinkExists = useNavLinkExists;
const useGetLinkInfo = () => {
  const normalizedLinks = useNormalizedAppLinks();
  return (0, _react.useCallback)(id => {
    const normalizedLink = normalizedLinks[id];
    if (!normalizedLink) {
      return undefined;
    }
    // discards the parentId and creates the linkInfo copy.
    const {
      parentId,
      ...linkInfo
    } = normalizedLink;
    return linkInfo;
  }, [normalizedLinks]);
};

/**
 * Hook to get the link info from an application link by id.
 * It returns the link info or undefined if it does not exist.
 */
exports.useGetLinkInfo = useGetLinkInfo;
const useLinkInfo = id => {
  const getLinkInfo = useGetLinkInfo();
  return (0, _react.useMemo)(() => getLinkInfo(id), [getLinkInfo, id]);
};

/**
 * Hook to check if a link exists in the application links,
 * It can be used to know if a link access is authorized.
 */
exports.useLinkInfo = useLinkInfo;
const useLinkAuthorized = id => {
  const linkInfo = useLinkInfo(id);
  return (0, _react.useMemo)(() => linkInfo != null && !linkInfo.unauthorized, [linkInfo]);
};

/**
 * Returns the `LinkInfo` of all the ancestors to the parameter id link, also included.
 */
exports.useLinkAuthorized = useLinkAuthorized;
const useParentLinks = id => {
  const normalizedLinks = useNormalizedAppLinks();
  return (0, _react.useMemo)(() => {
    const ancestors = [];
    let currentId = id;
    while (currentId) {
      const normalizedLink = normalizedLinks[currentId];
      if (normalizedLink) {
        const {
          parentId,
          ...linkInfo
        } = normalizedLink;
        ancestors.push(linkInfo);
        currentId = parentId;
      } else {
        currentId = undefined;
      }
    }
    return ancestors.reverse();
  }, [normalizedLinks, id]);
};
exports.useParentLinks = useParentLinks;