"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFirstLastSeen = void 0;
var _react = require("react");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_search_strategy = require("../use_search_strategy");
var _search_strategy = require("../../../../common/search_strategy");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFirstLastSeen = ({
  field,
  value,
  order,
  defaultIndex,
  filterQuery
}) => {
  const {
    loading,
    result,
    search,
    error
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _search_strategy.FirstLastSeenQuery,
    initialResult: {
      firstSeen: null,
      lastSeen: null
    },
    errorMessage: i18n.FAIL_FIRST_LAST_SEEN_HOST
  });
  (0, _react.useEffect)(() => {
    search({
      defaultIndex,
      field,
      value,
      order,
      filterQuery
    });
  }, [defaultIndex, field, value, order, search, filterQuery]);
  const setFirstLastSeenResponse = (0, _react.useMemo)(() => ({
    firstSeen: result.firstSeen,
    lastSeen: result.lastSeen,
    errorMessage: error ? error.toString() : null
  }), [result, error]);
  return [loading, setFirstLastSeenResponse];
};
exports.useFirstLastSeen = useFirstLastSeen;