"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _playground_header_docs = require("./playground_header_docs");
var _toolbar = require("./toolbar");
var _app = require("./app");
var _types = require("../types");
var _use_search_playground_feature_flag = require("../hooks/use_search_playground_feature_flag");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Header = ({
  selectedMode,
  onModeChange,
  showDocs = false,
  isActionsDisabled = false,
  selectedPageMode,
  onSelectPageModeChange
}) => {
  const isSearchModeEnabled = (0, _use_search_playground_feature_flag.useSearchPlaygroundFeatureFlag)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const options = [{
    id: _app.ViewMode.chat,
    label: selectedPageMode === _types.PlaygroundPageMode.chat ? _i18n.i18n.translate('xpack.searchPlayground.header.view.chat', {
      defaultMessage: 'Chat'
    }) : _i18n.i18n.translate('xpack.searchPlayground.header.view.preview', {
      defaultMessage: 'Preview'
    }),
    'data-test-subj': 'chatMode'
  }, {
    id: _app.ViewMode.query,
    label: _i18n.i18n.translate('xpack.searchPlayground.header.view.query', {
      defaultMessage: 'Query'
    }),
    'data-test-subj': 'queryMode'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    css: {
      '.euiPageHeaderContent > .euiFlexGroup': {
        flexWrap: 'wrap'
      },
      backgroundColor: euiTheme.colors.emptyShade
    },
    paddingSize: "s",
    "data-test-subj": "chat-playground-home-page"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    css: {
      whiteSpace: 'nowrap'
    },
    "data-test-subj": "chat-playground-home-page-title",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.pageTitle",
    defaultMessage: "Playground"
  }))), isSearchModeEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "page-mode-select",
    options: [{
      value: 'chat',
      text: 'Chat'
    }, {
      value: 'search',
      text: 'Search'
    }],
    value: selectedPageMode,
    onChange: e => onSelectPageModeChange(e.target.value)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.searchPlayground.pageTitle.techPreview', {
      defaultMessage: 'TECH PREVIEW'
    }),
    color: "hollow",
    alignment: "middle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: "viewMode",
    options: options,
    idSelected: selectedMode,
    onChange: id => onModeChange(id),
    buttonSize: "compressed",
    isDisabled: isActionsDisabled,
    "data-test-subj": "viewModeSelector"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, showDocs && /*#__PURE__*/_react.default.createElement(_playground_header_docs.PlaygroundHeaderDocs, null), /*#__PURE__*/_react.default.createElement(_toolbar.Toolbar, {
    selectedPageMode: selectedPageMode
  }))));
};
exports.Header = Header;