"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewMode = exports.App = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _reactHookForm = require("react-hook-form");
var _query_mode = require("./query_mode/query_mode");
var _chat_setup_page = require("./setup_page/chat_setup_page");
var _header = require("./header");
var _use_load_connectors = require("../hooks/use_load_connectors");
var _types = require("../types");
var _chat = require("./chat");
var _search_mode = require("./search_mode/search_mode");
var _search_playground_setup_page = require("./setup_page/search_playground_setup_page");
var _use_page_mode = require("../hooks/use_page_mode");
var _use_kibana = require("../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ViewMode = exports.ViewMode = /*#__PURE__*/function (ViewMode) {
  ViewMode["chat"] = "chat";
  ViewMode["query"] = "query";
  return ViewMode;
}({});
const App = ({
  showDocs = false,
  pageMode = _types.PlaygroundPageMode.chat
}) => {
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const [selectedMode, setSelectedMode] = (0, _react.useState)(ViewMode.chat);
  const {
    data: connectors
  } = (0, _use_load_connectors.useLoadConnectors)();
  const hasSelectedIndices = Boolean((0, _reactHookForm.useWatch)({
    name: _types.ChatFormFields.indices
  }).length);
  const handleModeChange = id => setSelectedMode(id);
  const handlePageModeChange = mode => {
    var _services$application;
    (_services$application = services.application) === null || _services$application === void 0 ? void 0 : _services$application.navigateToUrl(`./${mode}`);
    setSelectedPageMode(mode);
  };
  const {
    showSetupPage,
    pageMode: selectedPageMode,
    setPageMode: setSelectedPageMode
  } = (0, _use_page_mode.usePageMode)({
    hasSelectedIndices,
    hasConnectors: Boolean(connectors === null || connectors === void 0 ? void 0 : connectors.length),
    initialPageMode: pageMode === 'chat' ? _types.PlaygroundPageMode.chat : _types.PlaygroundPageMode.search
  });
  const restrictedWidth = selectedPageMode === _types.PlaygroundPageMode.search && selectedMode === 'chat';
  const paddingSize = selectedPageMode === _types.PlaygroundPageMode.search && selectedMode === 'chat' ? 'xl' : 'none';
  const getSetupPage = () => {
    return showSetupPage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedPageMode === _types.PlaygroundPageMode.chat && /*#__PURE__*/_react.default.createElement(_chat_setup_page.ChatSetupPage, null), selectedPageMode === _types.PlaygroundPageMode.search && /*#__PURE__*/_react.default.createElement(_search_playground_setup_page.SearchPlaygroundSetupPage, null));
  };
  const getQueryBuilderPage = () => {
    return !showSetupPage && selectedPageMode === _types.PlaygroundPageMode.search && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedMode === ViewMode.chat && /*#__PURE__*/_react.default.createElement(_search_mode.SearchMode, null), selectedMode === ViewMode.query && /*#__PURE__*/_react.default.createElement(_query_mode.QueryMode, null));
  };
  const getChatPage = () => {
    return !showSetupPage && selectedPageMode === _types.PlaygroundPageMode.chat && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedMode === ViewMode.chat && /*#__PURE__*/_react.default.createElement(_chat.Chat, null), selectedMode === ViewMode.query && /*#__PURE__*/_react.default.createElement(_query_mode.QueryMode, null));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.Header, {
    showDocs: showDocs,
    onModeChange: handleModeChange,
    selectedMode: selectedMode,
    isActionsDisabled: showSetupPage,
    selectedPageMode: selectedPageMode,
    onSelectPageModeChange: handlePageModeChange
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    alignment: "top",
    restrictWidth: restrictedWidth,
    grow: true,
    css: {
      position: 'relative'
    },
    contentProps: selectedPageMode === _types.PlaygroundPageMode.search && selectedMode === 'chat' ? undefined : {
      css: {
        display: 'flex',
        flexGrow: 1,
        position: 'absolute',
        inset: 0
      }
    },
    paddingSize: paddingSize,
    className: "eui-fullHeight"
  }, getSetupPage(), getChatPage(), getQueryBuilderPage()));
};
exports.App = App;