"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CsvSearchSourceImmediateExportType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _generateCsv = require("@kbn/generate-csv");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingExportTypesCsvCommon = require("@kbn/reporting-export-types-csv-common");
var _reportingServer = require("@kbn/reporting-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * ImmediateExecuteFn receives the job doc payload because the payload was
 * generated in the ScheduleFn
 */

/**
 * @deprecated
 * Requires `xpack.reporting.csv.enablePanelActionDownload` set to `true` (default is false)
 */
class CsvSearchSourceImmediateExportType extends _reportingServer.ExportType {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "id", _reportingExportTypesCsvCommon.CSV_SEARCHSOURCE_IMMEDIATE_TYPE);
    (0, _defineProperty2.default)(this, "name", _reportingExportTypesCsvCommon.CSV_SEARCHSOURCE_IMMEDIATE_TYPE);
    (0, _defineProperty2.default)(this, "jobType", _reportingExportTypesCsvCommon.CSV_SEARCHSOURCE_IMMEDIATE_TYPE);
    (0, _defineProperty2.default)(this, "jobContentEncoding", 'base64');
    (0, _defineProperty2.default)(this, "jobContentExtension", 'csv');
    (0, _defineProperty2.default)(this, "validLicenses", [_reportingCommon.LICENSE_TYPE_TRIAL, _reportingCommon.LICENSE_TYPE_BASIC, _reportingCommon.LICENSE_TYPE_CLOUD_STANDARD, _reportingCommon.LICENSE_TYPE_GOLD, _reportingCommon.LICENSE_TYPE_PLATINUM, _reportingCommon.LICENSE_TYPE_ENTERPRISE]);
    (0, _defineProperty2.default)(this, "createJob", async () => {
      throw new Error(`immediate download has no create job handler!`);
    });
    // @ts-ignore expected type failure from deprecated export type
    (0, _defineProperty2.default)(this, "runTask", async (_jobId, immediateJobParams, context, stream, req) => {
      const job = {
        objectType: 'immediate-search',
        ...immediateJobParams
      };
      const dataPluginStart = this.startDeps.data;
      const savedObjectsClient = (await context.core).savedObjects.client;
      const uiSettings = this.getUiSettingsServiceFactory(savedObjectsClient);
      const fieldFormatsRegistry = await (0, _reportingServer.getFieldFormats)().fieldFormatServiceFactory(uiSettings);
      const es = this.startDeps.esClient.asScoped(req);
      const searchSourceStart = await dataPluginStart.search.searchSource.asScoped(req);
      const clients = {
        uiSettings,
        data: dataPluginStart.search.asScoped(req),
        es
      };
      const dependencies = {
        fieldFormatsRegistry,
        searchSourceStart
      };
      const cancellationToken = new _reportingCommon.CancellationToken();
      const csvConfig = this.config.csv;
      const taskInstanceFields = csvConfig.scroll.duration === 'auto' ? {
        startedAt: new Date(),
        retryAt: new Date(Date.now() + (0, _reportingCommon.durationToNumber)(this.config.queue.timeout))
      } : {
        startedAt: null,
        retryAt: null
      };
      const csv = new _generateCsv.CsvGenerator(job, csvConfig, taskInstanceFields, clients, dependencies, cancellationToken, this.logger, stream);
      const result = await csv.generateData();
      if (result.csv_contains_formulas) {
        this.logger.warn(`CSV may contain formulas whose values have been escaped`);
      }
      if (result.max_size_reached) {
        this.logger.warn(`Max size reached: CSV output truncated`);
      }
      const {
        warnings
      } = result;
      if (warnings) {
        warnings.forEach(warning => {
          this.logger.warn(warning);
        });
      }
      return result;
    });
    this.logger = this.logger.get('csv-searchsource-export');
  }
}
exports.CsvSearchSourceImmediateExportType = CsvSearchSourceImmediateExportType;