"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsFlyout = AlertsFlyout;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _alerts_flyout_header = require("./alerts_flyout_header");
var _alerts_flyout_body = require("./alerts_flyout_body");
var _alerts_flyout_footer = require("./alerts_flyout_footer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertsFlyout({
  alert,
  alerts,
  onClose,
  selectedAlertId,
  observabilityRuleTypeRegistry
}) {
  const selectedAlert = (0, _react.useMemo)(() => alert !== null && alert !== void 0 ? alert : alerts === null || alerts === void 0 ? void 0 : alerts.find(a => a[_ruleDataUtils.ALERT_UUID] === selectedAlertId), [alert, alerts, selectedAlertId]);
  if (!selectedAlert) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    className: "oblt__flyout",
    onClose: onClose,
    size: "m",
    "data-test-subj": "alertsFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_alerts_flyout_header.AlertsFlyoutHeader, {
    alert: selectedAlert
  })), /*#__PURE__*/_react.default.createElement(_alerts_flyout_body.AlertsFlyoutBody, {
    alert: selectedAlert,
    observabilityRuleTypeRegistry: observabilityRuleTypeRegistry
  }), /*#__PURE__*/_react.default.createElement(_alerts_flyout_footer.AlertsFlyoutFooter, {
    alert: selectedAlert,
    observabilityRuleTypeRegistry: observabilityRuleTypeRegistry
  }));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = AlertsFlyout;