"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = void 0;
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = require("react");
var _translations = require("../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBreadcrumbs = () => {
  const logsLinkProps = (0, _public.useLinkProps)({
    app: _deeplinksObservability.LOGS_APP_ID
  });
  const logsExplorerLinkProps = (0, _public.useLinkProps)({
    app: _deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID
  });
  const classicCrumbs = (0, _react.useMemo)(() => {
    return [{
      text: _translations.logsAppTitle,
      ...logsLinkProps
    }, {
      text: _translations.logsExplorerAppTitle,
      ...logsExplorerLinkProps
    }];
  }, [logsExplorerLinkProps, logsLinkProps]);
  (0, _public.useBreadcrumbs)(classicCrumbs, {
    classicOnly: true
  });
};
exports.useBreadcrumbs = useBreadcrumbs;