"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_WORKER_ID = void 0;
var _xjson = require("./xjson");
var _painless = require("./painless");
var _sql = require("./sql");
var _monaco_imports = require("./monaco_imports");
var _esql = require("./esql");
var _yaml = require("./yaml");
var _helpers = require("./helpers");
var _console = require("./console");
var _kbnPublicPath__;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const DEFAULT_WORKER_ID = exports.DEFAULT_WORKER_ID = 'default';
const langSpecificWorkerIds = [_xjson.XJsonLang.ID, _painless.PainlessLang.ID, _monaco_imports.monaco.languages.json.jsonDefaults.languageId, _yaml.YAML_LANG_ID, _console.ConsoleLang.ID, _console.ConsoleOutputLang.ID];

/**
 * Register languages and lexer rules
 */
(0, _helpers.registerLanguage)(_xjson.XJsonLang);
(0, _helpers.registerLanguage)(_painless.PainlessLang);
(0, _helpers.registerLanguage)(_sql.SQLLang);
(0, _helpers.registerLanguage)(_esql.ESQLLang);
(0, _helpers.registerLanguage)(_console.ConsoleLang);
(0, _helpers.registerLanguage)(_console.ConsoleOutputLang);
const monacoBundleDir = (_kbnPublicPath__ = window.__kbnPublicPath__) === null || _kbnPublicPath__ === void 0 ? void 0 : _kbnPublicPath__['kbn-monaco'];
window.MonacoEnvironment = {
  // @ts-expect-error needed for functional tests so that we can get value from 'editor'
  monaco: _monaco_imports.monaco,
  getWorkerUrl: monacoBundleDir ? (_, languageId) => {
    const workerId = langSpecificWorkerIds.includes(languageId) ? languageId : DEFAULT_WORKER_ID;
    return `${monacoBundleDir}${workerId}.editor.worker.js`;
  } : () => ''
};