"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logRateAnalysisIndexOrSearchRouteFactory = exports.logCategorizationIndexOrSearchRouteFactory = exports.indexOrSearchRouteFactory = exports.explainLogRateSpikesIndexOrSearchRouteFactory = exports.dataVizIndexOrSearchRouteFactory = exports.changePointDetectionIndexOrSearchRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _locator = require("../../../../locator");
var _kibana = require("../../../contexts/kibana");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _resolvers = require("../../resolvers");
var _index_or_search = require("../../../jobs/new_job/pages/index_or_search");
var _breadcrumbs = require("../../breadcrumbs");
var _navigate_to_page_button = require("../../components/navigate_to_page_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var MODE = /*#__PURE__*/function (MODE) {
  MODE[MODE["NEW_JOB"] = 0] = "NEW_JOB";
  MODE[MODE["DATAVISUALIZER"] = 1] = "DATAVISUALIZER";
  return MODE;
}(MODE || {});
const Page = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../../../jobs/new_job/pages/index_or_search')))).Page
}));
const getBreadcrumbs = (navigateToPath, basePath) => [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ANOMALY_DETECTION_BREADCRUMB', navigateToPath, basePath), {
  text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.createJobLabel', {
    defaultMessage: 'Create job'
  })
}];
const getDataVisBreadcrumbs = (navigateToPath, basePath) => [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('DATA_VISUALIZER_BREADCRUMB', navigateToPath, basePath), {
  text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.selectDateViewLabel', {
    defaultMessage: 'Select Data View'
  })
}];
const getLogRateAnalysisBreadcrumbs = (navigateToPath, basePath) => [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('AIOPS_BREADCRUMB_LOG_RATE_ANALYSIS', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('LOG_RATE_ANALYSIS', navigateToPath, basePath), {
  text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbs.selectDataViewLabel', {
    defaultMessage: 'Select Data View'
  })
}];
const getLogCategorizationBreadcrumbs = (navigateToPath, basePath) => [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('LOG_PATTERN_ANALYSIS', navigateToPath, basePath), {
  text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbs.selectDataViewLabel', {
    defaultMessage: 'Select Data View'
  })
}];
const getChangePointDetectionBreadcrumbs = (navigateToPath, basePath) => [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('CHANGE_POINT_DETECTION', navigateToPath, basePath), {
  text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbs.selectDataViewLabel', {
    defaultMessage: 'Select Data View'
  })
}];
const indexOrSearchRouteFactory = (navigateToPath, basePath) => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_INDEX),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    nextStepPath: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_TYPE),
    deps: deps,
    mode: MODE.NEW_JOB
  })),
  breadcrumbs: getBreadcrumbs(navigateToPath, basePath)
});
exports.indexOrSearchRouteFactory = indexOrSearchRouteFactory;
const dataVizIndexOrSearchRouteFactory = (navigateToPath, basePath) => ({
  id: 'data_view_datavisualizer',
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_VISUALIZER_INDEX_SELECT),
  title: _i18n.i18n.translate('xpack.ml.selectDataViewLabel', {
    defaultMessage: 'Select Data View'
  }),
  render: (props, deps) => {
    const button = /*#__PURE__*/_react.default.createElement(_navigate_to_page_button.NavigateToPageButton, {
      nextStepPath: (0, _router.createPath)(_locator.ML_PAGES.DATA_VISUALIZER_ESQL),
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.datavisualizer.selector.useESQLButtonLabel",
        defaultMessage: "Use ES|QL"
      })
    });
    return /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
      nextStepPath: (0, _router.createPath)(_locator.ML_PAGES.DATA_VISUALIZER_INDEX_VIEWER),
      deps: deps,
      mode: MODE.DATAVISUALIZER,
      extraButtons: button
    }));
  },
  breadcrumbs: getDataVisBreadcrumbs(navigateToPath, basePath)
});
exports.dataVizIndexOrSearchRouteFactory = dataVizIndexOrSearchRouteFactory;
const logRateAnalysisIndexOrSearchRouteFactory = (navigateToPath, basePath) => ({
  id: 'data_view_log_rate_analysis',
  path: (0, _router.createPath)(_locator.ML_PAGES.AIOPS_LOG_RATE_ANALYSIS_INDEX_SELECT),
  title: _i18n.i18n.translate('xpack.ml.selectDataViewLabel', {
    defaultMessage: 'Select Data View'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    nextStepPath: (0, _router.createPath)(_locator.ML_PAGES.AIOPS_LOG_RATE_ANALYSIS),
    deps: deps,
    mode: MODE.DATAVISUALIZER
  })),
  breadcrumbs: getLogRateAnalysisBreadcrumbs(navigateToPath, basePath)
});

/**
 * @deprecated since 8.10, kept here to redirect old bookmarks.
 */
exports.logRateAnalysisIndexOrSearchRouteFactory = logRateAnalysisIndexOrSearchRouteFactory;
const explainLogRateSpikesIndexOrSearchRouteFactory = () => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.AIOPS_EXPLAIN_LOG_RATE_SPIKES_INDEX_SELECT),
  render: () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: (0, _router.createPath)(_locator.ML_PAGES.AIOPS_LOG_RATE_ANALYSIS_INDEX_SELECT)
  }),
  // no breadcrumbs since it's just a redirect
  breadcrumbs: []
});
exports.explainLogRateSpikesIndexOrSearchRouteFactory = explainLogRateSpikesIndexOrSearchRouteFactory;
const logCategorizationIndexOrSearchRouteFactory = (navigateToPath, basePath) => ({
  id: 'data_view_log_categorization',
  path: (0, _router.createPath)(_locator.ML_PAGES.AIOPS_LOG_CATEGORIZATION_INDEX_SELECT),
  title: _i18n.i18n.translate('xpack.ml.selectDataViewLabel', {
    defaultMessage: 'Select Data View'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    nextStepPath: (0, _router.createPath)(_locator.ML_PAGES.AIOPS_LOG_CATEGORIZATION),
    deps: deps,
    mode: MODE.DATAVISUALIZER
  })),
  breadcrumbs: getLogCategorizationBreadcrumbs(navigateToPath, basePath)
});
exports.logCategorizationIndexOrSearchRouteFactory = logCategorizationIndexOrSearchRouteFactory;
const changePointDetectionIndexOrSearchRouteFactory = (navigateToPath, basePath) => ({
  id: 'data_view_change_point_detection',
  path: (0, _router.createPath)(_locator.ML_PAGES.AIOPS_CHANGE_POINT_DETECTION_INDEX_SELECT),
  title: _i18n.i18n.translate('xpack.ml.selectDataViewLabel', {
    defaultMessage: 'Select Data View'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    nextStepPath: (0, _router.createPath)(_locator.ML_PAGES.AIOPS_CHANGE_POINT_DETECTION),
    deps: deps,
    mode: MODE.DATAVISUALIZER
  })),
  breadcrumbs: getChangePointDetectionBreadcrumbs(navigateToPath, basePath)
});
exports.changePointDetectionIndexOrSearchRouteFactory = changePointDetectionIndexOrSearchRouteFactory;
const PageWrapper = ({
  nextStepPath,
  mode,
  extraButtons
}) => {
  const {
    services: {
      http: {
        basePath
      },
      application: {
        navigateToUrl
      },
      data: {
        dataViews: dataViewsService
      }
    }
  } = (0, _kibana.useMlKibana)();
  const newJobResolvers = {
    ...(0, _resolvers.basicResolvers)(),
    preConfiguredJobRedirect: () => (0, _index_or_search.preConfiguredJobRedirect)(dataViewsService, basePath.get(), navigateToUrl)
  };
  const {
    context
  } = (0, _use_resolver.useRouteResolver)(mode === MODE.NEW_JOB ? 'full' : 'basic', mode === MODE.NEW_JOB ? ['canCreateJob'] : [], mode === MODE.NEW_JOB ? newJobResolvers : {});
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(Page, {
    nextStepPath,
    extraButtons
  }));
};