"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteActionModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteActionModal = ({
  closeModal,
  deleteAndCloseModal,
  deleteTargetIndex,
  deleteDataView,
  dataViewExists,
  isLoading,
  item,
  toggleDeleteIndex,
  toggleDeleteDataView,
  userCanDeleteIndex,
  userCanDeleteDataView
}) => {
  if (item === undefined) {
    return null;
  }
  const indexName = item.config.dest.index;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "mlAnalyticsJobDeleteModal",
    title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.deleteModalTitle', {
      defaultMessage: 'Delete {analyticsId}?',
      values: {
        analyticsId: item.config.id
      }
    }),
    onCancel: closeModal,
    onConfirm: deleteAndCloseModal,
    cancelButtonText: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.deleteModalCancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.deleteModalDeleteButton', {
      defaultMessage: 'Delete'
    }),
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
    buttonColor: "danger",
    confirmButtonDisabled: isLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, userCanDeleteIndex && /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "mlAnalyticsJobDeleteIndexSwitch",
    style: {
      paddingBottom: 10
    },
    label: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.deleteDestinationIndexTitle', {
      defaultMessage: 'Delete destination index {indexName}',
      values: {
        indexName
      }
    }),
    checked: deleteTargetIndex,
    onChange: toggleDeleteIndex
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, userCanDeleteIndex && dataViewExists && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "mlAnalyticsJobDeleteDataViewSwitch",
    label: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.deleteTargetDataViewTitle', {
      defaultMessage: 'Delete data view {dataView}',
      values: {
        dataView: indexName
      }
    }),
    checked: deleteDataView,
    onChange: toggleDeleteDataView,
    disabled: userCanDeleteDataView === false
  })))));
};
exports.DeleteActionModal = DeleteActionModal;