"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyLogViewCallout = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LegacyLogViewCallout = ({
  upgradeAssistantUrl
}) => {
  const UpgradeAssistant = upgradeAssistantUrl ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: upgradeAssistantUrl
  }, upgradeAssistantLabel) : upgradeAssistantLabel;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: legacyLogViewTitle,
    color: "warning",
    iconType: "alert"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.logsShared.logStream.legacyLogViewDescription",
    defaultMessage: "This view uses a deprecated configuration. Use the {UpgradeAssistant} to migrate to a supported configuration.",
    values: {
      UpgradeAssistant
    }
  })));
};
exports.LegacyLogViewCallout = LegacyLogViewCallout;
const legacyLogViewTitle = _i18n.i18n.translate('xpack.logsShared.logStream.legacyLogViewTitle', {
  defaultMessage: 'Deprecated Log Source Configuration'
});
const upgradeAssistantLabel = _i18n.i18n.translate('xpack.logsShared.logStream.upgradeAssistantLinkText', {
  defaultMessage: 'Upgrade Assistant'
});