"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicensePageHeader = exports.ExpiredLicensePageHeader = exports.ActiveLicensePageHeader = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _license_management = require("../../../store/reducers/license_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActiveLicensePageHeader = ({
  license,
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, (0, _extends2.default)({}, props, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "licenseText"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.licenseStatus.activeLicenseStatusTitle",
      defaultMessage: "Your {licenseType} license is {status}",
      values: {
        licenseType: license.type,
        status: license.status
      }
    })),
    description: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "licenseSubText"
    }, license.expirationDate ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.licenseStatus.activeLicenseStatusDescription",
      defaultMessage: "Your license will expire on {licenseExpirationDate}",
      values: {
        licenseExpirationDate: /*#__PURE__*/_react.default.createElement("strong", null, license.expirationDate)
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.licenseStatus.permanentActiveLicenseStatusDescription",
      defaultMessage: "Your license will never expire."
    }))
  }));
};
exports.ActiveLicensePageHeader = ActiveLicensePageHeader;
const ExpiredLicensePageHeader = ({
  license,
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, (0, _extends2.default)({}, props, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "licenseText"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.licenseStatus.expiredLicenseStatusTitle",
      defaultMessage: "Your {licenseType} license has expired",
      values: {
        licenseType: license.type
      }
    })),
    description: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "licenseSubText"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.licenseStatus.expiredLicenseStatusDescription",
      defaultMessage: "Your license expired on {licenseExpirationDate}",
      values: {
        licenseExpirationDate: /*#__PURE__*/_react.default.createElement("strong", null, license.expirationDate)
      }
    }))
  }));
};
exports.ExpiredLicensePageHeader = ExpiredLicensePageHeader;
const LicensePageHeader = () => {
  const license = (0, _reactRedux.useSelector)(_license_management.getLicenseState);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, license.isExpired ? /*#__PURE__*/_react.default.createElement(ExpiredLicensePageHeader, {
    license: license,
    bottomBorder: true,
    iconType: "warning",
    iconProps: {
      color: 'danger'
    }
  }) : /*#__PURE__*/_react.default.createElement(ActiveLicensePageHeader, {
    license: license,
    bottomBorder: true,
    iconType: "checkInCircleFilled",
    iconProps: {
      color: 'success'
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};
exports.LicensePageHeader = LicensePageHeader;