"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inventoryViewSavedObjectType = exports.inventoryViewSavedObjectName = void 0;
var _configSchema = require("@kbn/config-schema");
var _Either = require("fp-ts/lib/Either");
var _pipeable = require("fp-ts/lib/pipeable");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inventoryViewSavedObjectName = exports.inventoryViewSavedObjectName = 'inventory-view';
const getInventoryViewTitle = savedObject => (0, _pipeable.pipe)(_types.inventoryViewSavedObjectRT.decode(savedObject), (0, _Either.fold)(() => `Inventory view [id=${savedObject.id}]`, ({
  attributes: {
    name
  }
}) => name));
const schemaV1 = _configSchema.schema.object({}, {
  unknowns: 'allow'
});
const schemaV2 = _configSchema.schema.object({
  legend: _configSchema.schema.maybe(_configSchema.schema.object({
    steps: _configSchema.schema.number({
      max: 18,
      min: 2
    })
  }, {
    unknowns: 'allow'
  }))
}, {
  unknowns: 'allow'
});
const inventoryViewSavedObjectType = exports.inventoryViewSavedObjectType = {
  name: inventoryViewSavedObjectName,
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'name',
    displayName: 'inventory view',
    getTitle: getInventoryViewTitle,
    icon: 'metricsApp',
    importableAndExportable: true
  },
  mappings: {
    dynamic: false,
    properties: {}
  },
  modelVersions: {
    1: {
      changes: [],
      schemas: {
        create: schemaV1
      }
    },
    2: {
      changes: [{
        type: 'unsafe_transform',
        transformFn: document => {
          var _document$attributes$, _document$attributes$2;
          if (((_document$attributes$ = document.attributes.legend) === null || _document$attributes$ === void 0 ? void 0 : _document$attributes$.steps) > 18) {
            document.attributes.legend.steps = 18;
          } else if (((_document$attributes$2 = document.attributes.legend) === null || _document$attributes$2 === void 0 ? void 0 : _document$attributes$2.steps) < 2) {
            document.attributes.legend.steps = 2;
          }
          return {
            document
          };
        }
      }],
      schemas: {
        forwardCompatibility: schemaV2,
        create: schemaV2
      }
    }
  }
};