"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingEmbeddableFactoryCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MissingEmbeddableFactoryCallout = ({
  embeddableType
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    title: _i18n.i18n.translate('xpack.infra.missingEmebeddableFactoryCallout', {
      defaultMessage: "{embeddableType} embeddable is unavailable. This can happen if the embeddable plugin isn't enabled.",
      values: {
        embeddableType
      }
    })
  });
};
exports.MissingEmbeddableFactoryCallout = MissingEmbeddableFactoryCallout;