"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMessageContentImageUrl = isMessageContentImageUrl;
exports.isMessageContentText = isMessageContentText;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Type guard for image_url message content
 */
function isMessageContentImageUrl(content) {
  return content.type === 'image_url';
}

/**
 * Type guard for text message content
 */
function isMessageContentText(content) {
  return content.type === 'text';
}