"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchableSnapshot = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n_texts = require("../../../edit_policy/i18n_texts");
var _action_description = require("./action_description");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchableSnapshot = ({
  phase,
  phases
}) => {
  var _actions;
  const phaseConfig = phases[phase];
  const searchableSnapshot = (_actions = phaseConfig.actions) === null || _actions === void 0 ? void 0 : _actions.searchable_snapshot;
  return searchableSnapshot ? /*#__PURE__*/_react.default.createElement(_action_description.ActionDescription, {
    title: _i18n_texts.i18nTexts.editPolicy.searchableSnapshotLabel,
    descriptionItems: [/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${_i18n_texts.i18nTexts.editPolicy.searchableSnapshotsRepoFieldLabel}: `, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, searchableSnapshot.snapshot_repository))]
  }) : null;
};
exports.SearchableSnapshot = SearchableSnapshot;