"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Schema = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _schema = require("../../../../../shared/schema");
var _app_logic = require("../../../../app_logic");
var _view_content_header = require("../../../../components/shared/view_content_header");
var _constants = require("../../../../constants");
var _routes = require("../../../../routes");
var _source_layout = require("../source_layout");
var _constants2 = require("./constants");
var _schema_fields_table = require("./schema_fields_table");
var _schema_logic = require("./schema_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Schema = () => {
  const {
    initializeSchema,
    addNewField,
    updateFields,
    openAddFieldModal,
    closeAddFieldModal,
    setFilterValue
  } = (0, _kea.useActions)(_schema_logic.SchemaLogic);
  const {
    sourceId,
    activeSchema,
    filterValue,
    showAddFieldModal,
    addFieldFormErrors,
    mostRecentIndexJob,
    formUnchanged,
    dataLoading
  } = (0, _kea.useValues)(_schema_logic.SchemaLogic);
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  (0, _react.useEffect)(() => {
    initializeSchema();
  }, []);
  const hasSchemaFields = Object.keys(activeSchema).length > 0;
  const {
    hasErrors,
    activeReindexJobId
  } = mostRecentIndexJob;
  const addFieldButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    "data-test-subj": "AddFieldButton",
    onClick: openAddFieldModal
  }, _constants2.SCHEMA_ADD_FIELD_BUTTON);
  return /*#__PURE__*/_react.default.createElement(_source_layout.SourceLayout, {
    pageChrome: [_constants.NAV.SCHEMA],
    pageViewTelemetry: "source_schema",
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement(_view_content_header.ViewContentHeader, {
    title: _constants2.SCHEMA_MANAGE_SCHEMA_TITLE,
    description: _constants2.SCHEMA_MANAGE_SCHEMA_DESCRIPTION
  }), /*#__PURE__*/_react.default.createElement("div", null, hasErrors && /*#__PURE__*/_react.default.createElement(_schema.SchemaErrorsCallout, {
    viewErrorsPath: (0, _routes.getReindexJobRoute)(sourceId, activeReindexJobId.toString(), isOrganization)
  }), hasSchemaFields ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    value: filterValue,
    "data-test-subj": "FilterSchemaInput",
    placeholder: _constants2.SCHEMA_FILTER_PLACEHOLDER,
    onChange: e => setFilterValue(e.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, addFieldButton), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: formUnchanged,
    "data-test-subj": "UpdateTypesButton",
    onClick: updateFields,
    fill: true
  }, _constants2.SCHEMA_SAVE_BUTTON))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_schema_fields_table.SchemaFieldsTable, null)) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "managementApp",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants2.SCHEMA_EMPTY_SCHEMA_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", null, _constants2.SCHEMA_EMPTY_SCHEMA_DESCRIPTION),
    actions: addFieldButton
  }))), showAddFieldModal && /*#__PURE__*/_react.default.createElement(_schema.SchemaAddFieldModal, {
    addFieldFormErrors: addFieldFormErrors,
    addNewField: addNewField,
    closeAddFieldModal: closeAddFieldModal
  }));
};
exports.Schema = Schema;