"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartCrawlContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _crawl_custom_settings_flyout_logic = require("../../search_index/crawler/crawl_custom_settings_flyout/crawl_custom_settings_flyout_logic");
var _crawler_logic = require("../../search_index/crawler/crawler_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StartCrawlContextMenu = () => {
  const {
    reApplyCrawlRules,
    startCrawl
  } = (0, _kea.useActions)(_crawler_logic.CrawlerLogic);
  const {
    showFlyout: showCrawlCustomSettingsFlyout
  } = (0, _kea.useActions)(_crawl_custom_settings_flyout_logic.CrawlCustomSettingsFlyoutLogic);
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const togglePopover = () => setPopover(!isPopoverOpen);
  const closePopover = () => setPopover(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "arrowDown",
      iconSide: "right",
      onClick: togglePopover,
      fill: true,
      "data-test-subj": "entSearchContent-crawler-startCrawlMenu-menuButton"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusIndicator.retryCrawlButtonLabel', {
      defaultMessage: 'Crawl'
    })),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "crawl all domains",
      onClick: () => {
        closePopover();
        startCrawl();
      },
      icon: "play",
      "data-test-subj": "entSearchContent-crawler-startCrawlMenu-crawlAllDomains"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.startCrawlContextMenu.crawlAllDomainsMenuLabel', {
      defaultMessage: 'Crawl all domains on this index'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "crawl with custom settings",
      onClick: () => {
        closePopover();
        showCrawlCustomSettingsFlyout();
      },
      icon: "gear"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.startCrawlContextMenu.crawlCustomSettingsMenuLabel', {
      defaultMessage: 'Crawl with custom settings'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "reaply crawl rules",
      onClick: () => {
        closePopover();
        reApplyCrawlRules();
      },
      icon: "refresh"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.startCrawlContextMenu.reapplyCrawlRulesMenuLabel', {
      defaultMessage: 'Reapply crawl rules'
    }))]
  }));
};
exports.StartCrawlContextMenu = StartCrawlContextMenu;