"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DomainsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../shared/constants");
var _custom_formatted_timestamp = require("../../../../../shared/custom_formatted_timestamp/custom_formatted_timestamp");
var _encode_path_params = require("../../../../../shared/encode_path_params");
var _kibana = require("../../../../../shared/kibana");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _table_pagination = require("../../../../../shared/table_pagination");
var _routes = require("../../../../routes");
var _index_name_logic = require("../../index_name_logic");
var _delete_domain_modal_logic = require("./delete_domain_modal_logic");
var _domain_management_logic = require("./domain_management_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DomainsTable = () => {
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    domains,
    meta,
    isLoading
  } = (0, _kea.useValues)(_domain_management_logic.DomainManagementLogic);
  const {
    onPaginate
  } = (0, _kea.useActions)(_domain_management_logic.DomainManagementLogic);
  const {
    showModal
  } = (0, _kea.useActions)(_delete_domain_modal_logic.DeleteDomainModalLogic);
  const columns = [{
    field: 'url',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.domainsTable.column.domainURL', {
      defaultMessage: 'Domain'
    }),
    render: (_, domain) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: domain.url
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: copy,
      iconSize: "s",
      iconType: "copy"
    })), /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      "data-test-subj": "CrawlerDomainURL",
      to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_CRAWLER_DOMAIN_DETAIL_PATH, {
        domainId: domain.id,
        indexName,
        tabId: 'domain_management'
      })
    }, domain.url))
  }, {
    field: 'lastCrawl',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.domainsTable.column.lastActivity', {
      defaultMessage: 'Last activity'
    }),
    render: lastCrawl => lastCrawl ? /*#__PURE__*/_react.default.createElement(_custom_formatted_timestamp.CustomFormattedTimestamp, {
      timestamp: lastCrawl
    }) : ''
  }, {
    field: 'documentCount',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.domainsTable.column.documents', {
      defaultMessage: 'Documents'
    }),
    render: documentCount => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
      value: documentCount
    })
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.domainsTable.column.actions', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      name: _constants.MANAGE_BUTTON_LABEL,
      description: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.domainsTable.action.manage.buttonLabel', {
        defaultMessage: 'Manage this domain'
      }),
      type: 'icon',
      icon: 'eye',
      onClick: domain => {
        _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_CRAWLER_DOMAIN_DETAIL_PATH, {
          domainId: domain.id,
          indexName,
          tabId: 'domain_management'
        }));
      }
    }, {
      name: _constants.DELETE_BUTTON_LABEL,
      description: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.domainsTable.action.delete.buttonLabel', {
        defaultMessage: 'Delete this domain'
      }),
      type: 'icon',
      icon: 'trash',
      color: 'danger',
      onClick: domain => {
        showModal(domain);
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: isLoading,
    items: domains,
    columns: columns,
    pagination: {
      ...(0, _table_pagination.convertMetaToPagination)(meta),
      showPerPageOptions: false
    },
    onChange: (0, _table_pagination.handlePageChange)(onPaginate)
  });
};
exports.DomainsTable = DomainsTable;