"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelevanceTuningCallouts = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../shared/doc_links");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _routes = require("../../routes");
var _engine = require("../engine");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RelevanceTuningCallouts = () => {
  const {
    schemaFieldsWithConflicts
  } = (0, _kea.useValues)(_.RelevanceTuningLogic);
  const {
    engine: {
      invalidBoosts,
      unsearchedUnconfirmedFields
    }
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const schemaFieldsWithConflictsCount = schemaFieldsWithConflicts.length;
  const invalidBoostsCallout = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.invalidBoostsBannerLabel', {
      defaultMessage: 'You have invalid boosts!'
    }),
    "data-test-subj": "RelevanceTuningInvalidBoostsCallout"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.invalidBoostsErrorMessage', {
    defaultMessage: 'One or more of your boosts is no longer valid, possibly due to a schema type change. Delete any old or invalid boosts to dismiss this alert.'
  }));
  const unsearchedUnconfirmedFieldsCallout = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.uncofirmedFieldsBannerLabel', {
      defaultMessage: 'Recently added fields are not being searched by default'
    }),
    "data-test-subj": "RelevanceTuningUnsearchedFieldsCallout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.appSearch.engine.relevanceTuning.uncofirmedFieldsErrorMessage",
    defaultMessage: "If these new fields should be searchable, turn them on here by toggling Text Search. Otherwise, confirm your new {schemaLink} to dismiss this alert.",
    values: {
      schemaLink: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
        to: (0, _engine.generateEnginePath)(_routes.ENGINE_SCHEMA_PATH)
      }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.schemaFieldsLinkLabel', {
        defaultMessage: 'schema fields'
      }))
    }
  }));
  const schemaFieldsWithConflictsCallout = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.schemaConflictsBannerLabel', {
      defaultMessage: 'Disabled fields'
    }),
    "data-test-subj": "SchemaConflictsCallout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.appSearch.engine.relevanceTuning.schemaConflictsErrorMessage",
    defaultMessage: "{schemaFieldsWithConflictsCount, number} inactive {schemaFieldsWithConflictsCount, plural, one {field} other {fields}} due to field-type conflicts. {link}",
    values: {
      schemaFieldsWithConflictsCount,
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.appSearchMetaEngines,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.whatsThisLinkLabel', {
        defaultMessage: "What's this?"
      }))
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, invalidBoosts && invalidBoostsCallout(), unsearchedUnconfirmedFields && unsearchedUnconfirmedFieldsCallout(), schemaFieldsWithConflictsCount > 0 && schemaFieldsWithConflictsCallout());
};
exports.RelevanceTuningCallouts = RelevanceTuningCallouts;