"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryTester = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _engine = require("../engine");
var _result = require("../result");
var _search = require("../search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryTester = () => {
  const logic = (0, _search.SearchLogic)({
    id: 'query-tester'
  });
  const {
    searchQuery,
    searchResults,
    searchDataLoading
  } = (0, _kea.useValues)(logic);
  const {
    search
  } = (0, _kea.useActions)(logic);
  const {
    engine
  } = (0, _kea.useValues)(_engine.EngineLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    value: searchQuery,
    onChange: e => search(e.target.value),
    isLoading: searchDataLoading,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.queryTester.searchPlaceholder', {
      defaultMessage: 'Search engine documents'
    }),
    fullWidth: true,
    autoFocus: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), searchResults.length > 0 ? searchResults.map(result => {
    const id = result.id.raw;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: id
    }, /*#__PURE__*/_react.default.createElement(_result.Result, {
      isMetaEngine: false,
      key: id,
      result: result,
      schemaForTypeHighlights: engine.schema,
      showScore: true
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.addResult.searchEmptyDescription', {
      defaultMessage: 'No matching content found.'
    })
  }));
};
exports.QueryTester = QueryTester;