"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableCellActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TableCellActions = ({
  handleFilterFor,
  handleFilterOut
}) => {
  return /*#__PURE__*/_react.default.createElement("span", {
    className: "kbnDocTableCell__filter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    className: "kbnDocTableCell__filterButton",
    position: "bottom",
    content: _i18n.i18n.translate('discover.docTable.tableRow.filterForValueButtonTooltip', {
      defaultMessage: 'Filter for value'
    })
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "kbnDocTableRowFilterButton",
    "data-test-subj": "docTableCellFilter",
    "aria-label": _i18n.i18n.translate('discover.docTable.tableRow.filterForValueButtonAriaLabel', {
      defaultMessage: 'Filter for value'
    }),
    onClick: handleFilterFor
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "plusInCircle",
    size: "s",
    color: "primary"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    className: "kbnDocTableCell__filterButton",
    position: "bottom",
    content: _i18n.i18n.translate('discover.docTable.tableRow.filterOutValueButtonTooltip', {
      defaultMessage: 'Filter out value'
    })
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "kbnDocTableRowFilterButton",
    "data-test-subj": "docTableCellFilterNegate",
    "aria-label": _i18n.i18n.translate('discover.docTable.tableRow.filterOutValueButtonAriaLabel', {
      defaultMessage: 'Filter out value'
    }),
    onClick: handleFilterOut
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minusInCircle",
    size: "s",
    color: "primary"
  }))));
};
exports.TableCellActions = TableCellActions;