"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ContentType {
  constructor(definition) {
    this.definition = definition;
  }
  get id() {
    return this.definition.id;
  }
  get name() {
    var _this$definition$name;
    return (_this$definition$name = this.definition.name) !== null && _this$definition$name !== void 0 ? _this$definition$name : this.id;
  }
  get description() {
    var _this$definition$desc;
    return (_this$definition$desc = this.definition.description) !== null && _this$definition$desc !== void 0 ? _this$definition$desc : '';
  }
  get icon() {
    var _this$definition$icon;
    return (_this$definition$icon = this.definition.icon) !== null && _this$definition$icon !== void 0 ? _this$definition$icon : 'question';
  }
  get crud() {
    return this.definition.crud;
  }
  get version() {
    return this.definition.version;
  }
}
exports.ContentType = ContentType;