"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PagePreview = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _dom_preview = require("../dom_preview");
var _page_controls = require("./page_controls");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PagePreview = ({
  isWriteable,
  page,
  height,
  onDuplicate,
  onRemove
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasPageManager__pagePreview",
  style: {
    backgroundColor: page.style.background
  }
}, /*#__PURE__*/_react.default.createElement(_dom_preview.DomPreview, {
  elementId: page.id,
  height: height
}), isWriteable && /*#__PURE__*/_react.default.createElement(_page_controls.PageControls, {
  pageId: page.id,
  onDuplicate: onDuplicate,
  onRemove: onRemove
}));
exports.PagePreview = PagePreview;
PagePreview.propTypes = {
  isWriteable: _propTypes.default.bool.isRequired,
  page: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    style: _propTypes.default.shape({
      background: _propTypes.default.string.isRequired
    }).isRequired
  }).isRequired,
  height: _propTypes.default.number.isRequired,
  onDuplicate: _propTypes.default.func.isRequired,
  onRemove: _propTypes.default.func.isRequired
};