"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeTicksTZ = exports.getDomainTZ = void 0;
exports.getTimeZone = getTimeZone;
var _d = _interopRequireDefault(require("d3"));
var _common = require("@kbn/data-plugin/common");
var _get_timezone_offset_in_ms = require("./get_timezone_offset_in_ms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimeTicksTZ = ({
  domain,
  totalTicks,
  width
}) => _d.default.time.scale.utc().domain(domain).range([0, width]).ticks(totalTicks).map(x => {
  const time = x.getTime();
  return new Date(time + (0, _get_timezone_offset_in_ms.getTimezoneOffsetInMs)(time));
});
exports.getTimeTicksTZ = getTimeTicksTZ;
const getDomainTZ = (min, max) => {
  const [xMinZone, xMaxZone] = [min, max].map(time => time - (0, _get_timezone_offset_in_ms.getTimezoneOffsetInMs)(time));
  return [xMinZone, xMaxZone];
};
exports.getDomainTZ = getDomainTZ;
function getTimeZone(uiSettings) {
  const kibanaTimeZone = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_common.UI_SETTINGS.DATEFORMAT_TZ);
  if (!kibanaTimeZone || kibanaTimeZone === 'Browser') {
    return 'local';
  }
  return kibanaTimeZone;
}