"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNewAPIKeySet = createNewAPIKeySet;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createNewAPIKeySet(context, {
  id,
  ruleName,
  username,
  shouldUpdateApiKey,
  errorMessage
}) {
  let createdAPIKey = null;
  let isAuthTypeApiKey = false;
  try {
    isAuthTypeApiKey = context.isAuthenticationTypeAPIKey();
    const name = (0, _common.generateAPIKeyName)(id, ruleName);
    createdAPIKey = shouldUpdateApiKey ? isAuthTypeApiKey ? context.getAuthenticationAPIKey(`${name}-user-created`) : await context.createAPIKey(name) : null;
  } catch (error) {
    const message = errorMessage ? errorMessage : 'Error creating API key for rule';
    throw _boom.default.badRequest(`${message} - ${error.message}`);
  }
  return (0, _common.apiKeyAsAlertAttributes)(createdAPIKey, username, isAuthTypeApiKey);
}