"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusFilter = exports.StatusFilter = /*#__PURE__*/_react.default.memo(({
  selectedStatus,
  onChange
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onFilterItemClick = (0, _react.useCallback)(newOption => () => {
    const options = selectedStatus.includes(newOption) ? selectedStatus.filter(option => option !== newOption) : [...selectedStatus, newOption];
    onChange(options);
  }, [onChange, selectedStatus]);
  const openPopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(prevIsOpen => !prevIsOpen);
  }, [setIsPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": "status-filter-button",
      iconType: "arrowDown",
      isSelected: isPopoverOpen,
      hasActiveFilters: selectedStatus.length > 0,
      numActiveFilters: selectedStatus.length,
      numFilters: selectedStatus.length,
      onClick: openPopover
    }, i18n.TABLE_STATUS)
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _constants.STATUS_OPTIONS.map(status => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      key: status.value,
      "data-test-subj": `status-filter-${status.value}`,
      onClick: onFilterItemClick(status.value),
      checked: selectedStatus.includes(status.value) ? 'on' : undefined
    }, status.name);
  }))));
});
StatusFilter.displayName = 'StatusFilter';