"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const js_sdk_common_1 = require("@launchdarkly/js-sdk-common");
const isExperiment_1 = require("./isExperiment");
/**
 * @internal
 */
class EventFactory extends js_sdk_common_1.internal.EventFactoryBase {
    evalEventServer(flag, context, detail, defaultVal, prereqOfFlag) {
        var _a;
        const addExperimentData = (0, isExperiment_1.default)(flag, detail.reason);
        return super.evalEvent({
            addExperimentData,
            context,
            debugEventsUntilDate: flag.debugEventsUntilDate,
            defaultVal,
            excludeFromSummaries: flag.excludeFromSummaries,
            flagKey: flag.key,
            prereqOfFlagKey: prereqOfFlag === null || prereqOfFlag === void 0 ? void 0 : prereqOfFlag.key,
            reason: detail.reason,
            samplingRatio: flag.samplingRatio,
            trackEvents: flag.trackEvents || addExperimentData,
            value: detail.value,
            variation: (_a = detail.variationIndex) !== null && _a !== void 0 ? _a : undefined,
            version: flag.version,
        });
    }
}
exports.default = EventFactory;
//# sourceMappingURL=EventFactory.js.map