"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @internal
 */
class NamespacedDataSet {
    constructor() {
        this._itemsByNamespace = {};
    }
    get(namespace, key) {
        var _a;
        return (_a = this._itemsByNamespace[namespace]) === null || _a === void 0 ? void 0 : _a[key];
    }
    set(namespace, key, value) {
        if (!(namespace in this._itemsByNamespace)) {
            this._itemsByNamespace[namespace] = {};
        }
        this._itemsByNamespace[namespace][key] = value;
    }
    remove(namespace, key) {
        const items = this._itemsByNamespace[namespace];
        if (items) {
            delete items[key];
        }
    }
    removeAll() {
        this._itemsByNamespace = {};
    }
    enumerate(callback) {
        Object.entries(this._itemsByNamespace).forEach(([namespace, values]) => {
            Object.entries(values).forEach(([key, value]) => {
                callback(namespace, key, value);
            });
        });
    }
    mergeFrom(other) {
        other.enumerate(this.set.bind(this));
    }
}
exports.default = NamespacedDataSet;
//# sourceMappingURL=NamespacedDataSet.js.map