"use strict";
/* eslint-disable max-classes-per-file */
// Disabling max classes per file as these are tag classes without
// logic implementation.
Object.defineProperty(exports, "__esModule", { value: true });
exports.LDConcurrentExecution = exports.LDSerialExecution = exports.LDExecution = exports.LDExecutionOrdering = void 0;
/**
 * When execution is sequential this enum is used to control if execution
 * should be in a fixed or random order.
 */
var LDExecutionOrdering;
(function (LDExecutionOrdering) {
    LDExecutionOrdering[LDExecutionOrdering["Fixed"] = 0] = "Fixed";
    LDExecutionOrdering[LDExecutionOrdering["Random"] = 1] = "Random";
})(LDExecutionOrdering || (exports.LDExecutionOrdering = LDExecutionOrdering = {}));
/**
 * Tag used to determine if execution should be serial or concurrent.
 * Callers should not need to use this directly.
 */
var LDExecution;
(function (LDExecution) {
    /**
     * Execution will be serial. One read method will be executed fully before
     * the other read method.
     */
    LDExecution[LDExecution["Serial"] = 0] = "Serial";
    /**
     * Execution will be concurrent. The execution of the read methods will be
     * started and then resolved concurrently.
     */
    LDExecution[LDExecution["Concurrent"] = 1] = "Concurrent";
})(LDExecution || (exports.LDExecution = LDExecution = {}));
/**
 * Configuration class for configuring serial execution of a migration.
 */
class LDSerialExecution {
    constructor(ordering) {
        this.ordering = ordering;
        this.type = LDExecution.Serial;
    }
}
exports.LDSerialExecution = LDSerialExecution;
/**
 * Configuration class for configuring concurrent execution of a migration.
 */
class LDConcurrentExecution {
    constructor() {
        this.type = LDExecution.Concurrent;
    }
}
exports.LDConcurrentExecution = LDConcurrentExecution;
//# sourceMappingURL=LDMigrationOptions.js.map