"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PagerDutyActionFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _form_errors = require("../../../../../components/form_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PagerDutyActionFields = ({
  errors,
  hasErrors,
  action,
  editAction,
  children
}) => {
  const {
    description
  } = action;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, children, /*#__PURE__*/_react.default.createElement(_form_errors.ErrableFormRow, {
    id: "pagerDutyDescription",
    errorKey: "description",
    fullWidth: true,
    errors: errors,
    isShowingErrors: hasErrors && description !== undefined,
    label: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.threshold.pagerDutyAction.descriptionFieldLabel', {
      defaultMessage: 'Description'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: "description",
    value: description || '',
    "data-test-subj": "pagerdutyDescriptionInput",
    onChange: e => {
      editAction({
        key: 'description',
        value: e.target.value
      });
    },
    onBlur: () => {
      if (!description) {
        editAction({
          key: 'description',
          value: ''
        });
      }
    }
  })));
};
exports.PagerDutyActionFields = PagerDutyActionFields;