"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortColumns = exports.isValidVis = exports.isReferenced = exports.getMetricsWithoutDuplicates = exports.getCustomBucketColumns = exports.getColumnsWithoutReferenced = exports.getColumnIds = exports.getBucketColumns = exports.getBucketCollapseFn = void 0;
var _common = require("../../common");
var _buckets = require("../../common/convert_to_lens/lib/buckets");
var _utils = require("../../common/convert_to_lens/lib/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isReferenced = (columnId, references) => references.includes(columnId);
exports.isReferenced = isReferenced;
const getColumnsWithoutReferenced = columns => {
  const references = Object.values(columns).flatMap(col => 'references' in col ? col.references : []);
  return columns.filter(({
    columnId
  }) => !isReferenced(columnId, references));
};
exports.getColumnsWithoutReferenced = getColumnsWithoutReferenced;
const getBucketCollapseFn = (metrics, customBucketColumns, customBucketsMap, metricColumns) => {
  const collapseFnMap = {
    min: [],
    max: [],
    sum: [],
    avg: []
  };
  customBucketColumns.forEach(bucket => {
    const metricColumnsIds = Object.keys(customBucketsMap).filter(key => customBucketsMap[key] === bucket.columnId);
    metricColumnsIds.forEach(metricColumnsId => {
      var _metrics$find;
      const metricColumn = metricColumns.find(c => c.columnId === metricColumnsId);
      const collapseFn = (_metrics$find = metrics.find(m => m.aggId === metricColumn.meta.aggId)) === null || _metrics$find === void 0 ? void 0 : _metrics$find.aggType.split('_')[0];
      if ((0, _common.isCollapseFunction)(collapseFn)) {
        if (collapseFn) {
          collapseFnMap[collapseFn].push(bucket.columnId);
        }
      }
    });
  });
  return collapseFnMap;
};
exports.getBucketCollapseFn = getBucketCollapseFn;
const getBucketColumns = (visType, visSchemas, keys, dataView, isSplit, metricColumns, dropEmptyRowsInDateHistogram = false) => {
  const columns = [];
  for (const key of keys) {
    var _visSchemas$key;
    if (visSchemas[key] && (_visSchemas$key = visSchemas[key]) !== null && _visSchemas$key !== void 0 && _visSchemas$key.length) {
      var _visSchemas$key2;
      const bucketColumns = (_visSchemas$key2 = visSchemas[key]) === null || _visSchemas$key2 === void 0 ? void 0 : _visSchemas$key2.flatMap(m => (0, _buckets.convertBucketToColumns)({
        agg: m,
        dataView,
        visType,
        metricColumns,
        aggs: visSchemas.metric
      }, isSplit, dropEmptyRowsInDateHistogram));
      if (!bucketColumns || bucketColumns.includes(null)) {
        return null;
      }
      columns.push(...bucketColumns);
    }
  }
  return columns;
};
exports.getBucketColumns = getBucketColumns;
const isValidVis = (visSchemas, supportMixedSiblingPipelineAggs) => {
  const {
    metric
  } = visSchemas;
  const siblingPipelineAggs = metric.filter(m => (0, _utils.isSiblingPipeline)(m));
  if (!siblingPipelineAggs.length) {
    return true;
  }

  // doesn't support mixed sibling pipeline aggregations
  if (siblingPipelineAggs.some(agg => agg.aggType !== siblingPipelineAggs[0].aggType) && !supportMixedSiblingPipelineAggs) {
    return false;
  }
  return true;
};
exports.isValidVis = isValidVis;
const getMetricsWithoutDuplicates = metrics => metrics.reduce((acc, metric) => {
  if (metric.aggId && !acc.some(m => m.aggId === metric.aggId)) {
    acc.push(metric);
  }
  return acc;
}, []);
exports.getMetricsWithoutDuplicates = getMetricsWithoutDuplicates;
const sortColumns = (columns, visSchemas, bucketsAndSplitsKeys, metricsWithoutDuplicates) => {
  const aggOrderMap = ['metric', ...bucketsAndSplitsKeys].reduce((acc, key) => {
    var _ref;
    return {
      ...acc,
      ...((_ref = key === 'metric' ? metricsWithoutDuplicates : visSchemas[key]) === null || _ref === void 0 ? void 0 : _ref.reduce((newAcc, schema) => {
        // metrics should always have sort more than buckets
        newAcc[schema.aggId] = key === 'metric' ? schema.accessor : 1000 + schema.accessor;
        return newAcc;
      }, {}))
    };
  }, {});
  return columns.sort((a, b) => Number(aggOrderMap[a.meta.aggId.split('-')[0]]) - Number(aggOrderMap[b.meta.aggId.split('-')[0]]));
};
exports.sortColumns = sortColumns;
const getColumnIds = columns => columns.map(({
  columnId
}) => columnId);
exports.getColumnIds = getColumnIds;
const getCustomBucketColumns = (visType, customBucketsWithMetricIds, metricColumns, dataView, aggs, dropEmptyRowsInDateHistogram) => {
  const customBucketColumns = [];
  const customBucketsMap = {};
  customBucketsWithMetricIds.forEach(customBucketWithMetricIds => {
    const customBucketColumn = (0, _buckets.convertBucketToColumns)({
      agg: customBucketWithMetricIds.customBucket,
      dataView,
      metricColumns,
      aggs,
      visType
    }, true, dropEmptyRowsInDateHistogram);
    customBucketColumns.push(customBucketColumn);
    if (customBucketColumn) {
      customBucketWithMetricIds.metricIds.forEach(metricAggId => {
        var _metricColumns$find;
        const metricColumnId = (_metricColumns$find = metricColumns.find(metricColumn => (metricColumn === null || metricColumn === void 0 ? void 0 : metricColumn.meta.aggId) === metricAggId)) === null || _metricColumns$find === void 0 ? void 0 : _metricColumns$find.columnId;
        if (metricColumnId) {
          customBucketsMap[metricColumnId] = customBucketColumn.columnId;
        }
      });
    }
  });
  return {
    customBucketColumns,
    customBucketsMap
  };
};
exports.getCustomBucketColumns = getCustomBucketColumns;