"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.histogramVisTypeDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _public3 = require("@kbn/charts-plugin/public");
var _types = require("../types");
var _to_ast = require("../to_ast");
var _common = require("../../common");
var _common_config = require("../editor/common_config");
var _get_vis_type_from_params = require("./get_vis_type_from_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const histogramVisTypeDefinition = exports.histogramVisTypeDefinition = {
  name: 'histogram',
  title: _i18n.i18n.translate('visTypeXy.histogram.histogramTitle', {
    defaultMessage: 'Vertical bar'
  }),
  icon: 'visBarVertical',
  description: _i18n.i18n.translate('visTypeXy.histogram.histogramDescription', {
    defaultMessage: 'Present data in vertical bars on an axis.'
  }),
  fetchDatatable: true,
  toExpressionAst: _to_ast.toExpressionAst,
  getSupportedTriggers: () => [_public2.VIS_EVENT_TO_TRIGGER.filter, _public2.VIS_EVENT_TO_TRIGGER.brush],
  updateVisTypeOnParamsChange: _get_vis_type_from_params.getVisTypeFromParams,
  visConfig: {
    defaults: {
      type: _common.ChartType.Histogram,
      grid: {
        categoryLines: false
      },
      categoryAxes: [{
        id: 'CategoryAxis-1',
        type: _types.AxisType.Category,
        position: _charts.Position.Bottom,
        show: true,
        scale: {
          type: _types.ScaleType.Linear
        },
        labels: {
          show: true,
          filter: true,
          truncate: 100
        },
        title: {},
        style: {}
      }],
      valueAxes: [{
        id: 'ValueAxis-1',
        name: 'LeftAxis-1',
        type: _types.AxisType.Value,
        position: _charts.Position.Left,
        show: true,
        scale: {
          type: _types.ScaleType.Linear,
          mode: _types.AxisMode.Normal
        },
        labels: {
          show: true,
          rotate: _public3.LabelRotation.Horizontal,
          filter: true,
          truncate: 100
        },
        title: {
          text: ''
        },
        style: {}
      }],
      seriesParams: [{
        show: true,
        type: _common.ChartType.Histogram,
        mode: _types.ChartMode.Stacked,
        data: {
          label: _public3.defaultCountLabel,
          id: '1'
        },
        interpolate: _types.InterpolationMode.Linear,
        valueAxis: 'ValueAxis-1',
        drawLinesBetweenPoints: true,
        lineWidth: 2,
        showCircles: true,
        circlesRadius: 1
      }],
      radiusRatio: 0,
      addTooltip: true,
      detailedTooltip: true,
      palette: {
        type: 'palette',
        name: 'default'
      },
      addLegend: true,
      legendPosition: _charts.Position.Right,
      times: [],
      addTimeMarker: false,
      truncateLegend: true,
      maxLegendLines: 1,
      labels: {
        show: false
      },
      thresholdLine: {
        show: false,
        value: 10,
        width: 1,
        style: _types.ThresholdLineStyle.Full,
        color: (0, _eui.euiPaletteColorBlind)()[9]
      }
    }
  },
  editorConfig: {
    enableDataViewChange: true,
    optionTabs: _common_config.optionTabs,
    schemas: [{
      group: _public.AggGroupNames.Metrics,
      name: 'metric',
      title: _i18n.i18n.translate('visTypeXy.histogram.metricTitle', {
        defaultMessage: 'Y-axis'
      }),
      min: 1,
      aggFilter: ['!geo_centroid', '!geo_bounds', '!filtered_metric', '!single_percentile', '!single_percentile_rank'],
      defaults: [{
        schema: 'metric',
        type: 'count'
      }]
    }, {
      group: _public.AggGroupNames.Metrics,
      name: 'radius',
      title: _i18n.i18n.translate('visTypeXy.histogram.radiusTitle', {
        defaultMessage: 'Dot size'
      }),
      min: 0,
      max: 1,
      aggFilter: ['count', 'avg', 'sum', 'min', 'max', 'cardinality']
    }, {
      group: _public.AggGroupNames.Buckets,
      name: 'segment',
      title: _i18n.i18n.translate('visTypeXy.histogram.segmentTitle', {
        defaultMessage: 'X-axis'
      }),
      min: 0,
      max: 1,
      aggFilter: ['!geotile_grid', '!filter', '!sampler', '!diversified_sampler', '!rare_terms', '!multi_terms', '!significant_text']
    }, {
      group: _public.AggGroupNames.Buckets,
      name: 'group',
      title: _i18n.i18n.translate('visTypeXy.histogram.groupTitle', {
        defaultMessage: 'Split series'
      }),
      min: 0,
      max: 3,
      aggFilter: ['!geotile_grid', '!filter', '!sampler', '!diversified_sampler', '!rare_terms', '!multi_terms', '!significant_text']
    }, {
      group: _public.AggGroupNames.Buckets,
      name: 'split',
      title: _i18n.i18n.translate('visTypeXy.histogram.splitTitle', {
        defaultMessage: 'Split chart'
      }),
      min: 0,
      max: 1,
      aggFilter: ['!geotile_grid', '!filter', '!sampler', '!diversified_sampler', '!rare_terms', '!multi_terms', '!significant_text']
    }]
  },
  requiresSearch: true
};