"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = VegaVisEditor;
var _monaco = require("@kbn/monaco");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _hjson = _interopRequireDefault(require("hjson"));
var _react = _interopRequireWildcard(require("react"));
var _jsonStringifyPrettyCompact = _interopRequireDefault(require("json-stringify-pretty-compact"));
var _i18n = require("@kbn/i18n");
var _codeEditor = require("@kbn/code-editor");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _services = require("../services");
var _vega_help_menu = require("./vega_help_menu");
var _vega_actions_menu = require("./vega_actions_menu");
require("./vega_editor.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function format(value, stringify, options) {
  try {
    const spec = _hjson.default.parse(value, {
      legacyRoot: false,
      keepWsc: true
    });
    return {
      value: stringify(spec, options),
      isValid: true
    };
  } catch (err) {
    // This is a common case - user tries to format an invalid HJSON text
    (0, _services.getNotifications)().toasts.addError(err, {
      title: _i18n.i18n.translate('visTypeVega.editor.formatError', {
        defaultMessage: 'Error formatting spec'
      })
    });
    return {
      value,
      isValid: false
    };
  }
}
const useMemoCss = styleMap => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const outputStyles = (0, _react.useMemo)(() => {
    return Object.entries(styleMap).reduce((acc, [key, value]) => {
      acc[key] = typeof value === 'function' ? value(euiThemeContext) : value;
      return acc;
    }, {});
  }, [euiThemeContext, styleMap]);
  return outputStyles;
};
const monacoOverride = {
  override: ({
    colorMode
  }) => (0, _react2.css)({
    // See discussion: https://github.com/elastic/kibana/issues/228296#issuecomment-3126033291
    ...(colorMode === 'DARK' && {
      '.monaco-editor': {
        '--vscode-editor-inactiveSelectionBackground': '#3a3d41'
      }
    })
  })
};
function VegaVisEditor({
  stateParams,
  setValue
}) {
  const monacoStyles = useMemoCss(monacoOverride);
  const [languageId, setLanguageId] = (0, _react.useState)();
  (0, _useMount.default)(() => {
    let specLang = _monaco.XJsonLang.ID;
    try {
      JSON.parse(stateParams.spec);
    } catch {
      specLang = _codeEditor.HJsonLang;
    }
    setLanguageId(specLang);
  });
  const setSpec = (0, _react.useCallback)((value, specLang) => {
    setValue('spec', value);
    if (specLang) {
      setLanguageId(specLang);
    }
  }, [setValue]);
  const onChange = (0, _react.useCallback)(value => setSpec(value), [setSpec]);
  const formatJson = (0, _react.useCallback)(() => {
    const {
      value,
      isValid
    } = format(stateParams.spec, _jsonStringifyPrettyCompact.default);
    if (isValid) {
      setSpec(value, _monaco.XJsonLang.ID);
    }
  }, [setSpec, stateParams.spec]);
  const formatHJson = (0, _react.useCallback)(() => {
    const {
      value,
      isValid
    } = format(stateParams.spec, _hjson.default.stringify, {
      bracesSameLine: true,
      keepWsc: true
    });
    if (isValid) {
      setSpec(value, _codeEditor.HJsonLang);
    }
  }, [setSpec, stateParams.spec]);
  if (!languageId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "vgaEditor",
    "data-test-subj": "vega-editor"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "vgaEditor__editorActions"
  }, /*#__PURE__*/_react.default.createElement(_vega_help_menu.VegaHelpMenu, null), /*#__PURE__*/_react.default.createElement(_vega_actions_menu.VegaActionsMenu, {
    formatHJson: formatHJson,
    formatJson: formatJson
  })), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    classNameCss: monacoStyles.override,
    width: "100%",
    height: "100%",
    languageId: languageId,
    value: stateParams.spec,
    onChange: onChange,
    options: {
      lineNumbers: 'on',
      fontSize: 12,
      minimap: {
        enabled: false
      },
      folding: true,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true
    }
  }));
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;