"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateCoordinates = calculateCoordinates;
var _reactDom = require("react-dom");
var _calc_dimensions = require("./calc_dimensions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function calculateCoordinates(innerRef, resizeRef, state) {
  const inner = (0, _reactDom.findDOMNode)(innerRef);
  const resize = (0, _reactDom.findDOMNode)(resizeRef);
  let scale = state.scale;

  // Let's start by scaling to the largest dimension
  if (resize.clientWidth - resize.clientHeight < 0) {
    scale = resize.clientWidth / inner.clientWidth;
  } else {
    scale = resize.clientHeight / inner.clientHeight;
  }
  let [newWidth, newHeight] = (0, _calc_dimensions.calcDimensions)(inner, scale);

  // Now we need to check to see if it will still fit
  if (newWidth > resize.clientWidth) {
    scale = resize.clientWidth / inner.clientWidth;
  }
  if (newHeight > resize.clientHeight) {
    scale = resize.clientHeight / inner.clientHeight;
  }

  // Calculate the final dimensions
  [newWidth, newHeight] = (0, _calc_dimensions.calcDimensions)(inner, scale);

  // Because scale is middle out we need to translate
  // the new X,Y coordinates
  const translateX = (newWidth - inner.clientWidth) / 2;
  const translateY = (newHeight - inner.clientHeight) / 2;

  // Center up and down
  const top = Math.floor((resize.clientHeight - newHeight) / 2);
  const left = Math.floor((resize.clientWidth - newWidth) / 2);
  return {
    scale,
    top,
    left,
    translateY,
    translateX
  };
}