"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _tick_formatter = require("./lib/tick_formatter");
var _convert_series_to_vars = require("./lib/convert_series_to_vars");
var _lodash = _interopRequireDefault(require("lodash"));
var _codeEditor = require("@kbn/code-editor");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../services");
var _index_patterns_utils = require("../../../common/index_patterns_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/* eslint-disable jsx-a11y/anchor-is-valid, jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions */
// Markdown builder is not yet properly accessible

const editorStyle = ({
  euiTheme
}) => (0, _react2.css)`
  display: flex;
  background-color: ${euiTheme.colors.emptyShade};
  height: 500px;
`;
const panelStyle = (0, _react2.css)`
  width: 50%;
  flex: 1 0 auto;
`;
const editorPanelStyle = ({
  euiTheme
}) => (0, _react2.css)`
  border-right: 2px solid ${euiTheme.colors.lightestShade};
`;
const variablesPanelStyle = ({
  euiTheme
}) => (0, _react2.css)`
  padding: ${euiTheme.size.s};
  overflow: auto;
`;
const noVariablesStyle = ({
  euiTheme
}) => (0, _react2.css)`
  display: block;
  padding-bottom: ${euiTheme.size.xxl};
  padding-top: calc(${euiTheme.size.xxl} - ${euiTheme.size.l});
  text-align: center;
  border-bottom: ${euiTheme.border.thin};
`;
class MarkdownEditor extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handleChange", value => {
      this.props.onChange({
        markdown: value
      });
    });
    (0, _defineProperty2.default)(this, "handleOnLoad", editor => {
      this.editor = editor;
    });
    (0, _defineProperty2.default)(this, "handleVarClick", snippet => () => {
      if (this.editor) {
        const range = this.editor.getSelection();
        this.editor.executeEdits('', [{
          range,
          text: snippet
        }]);
      }
    });
    this.state = {
      fieldFormatMap: undefined
    };
  }
  async componentDidMount() {
    const dataViews = (0, _services.getDataViewsStart)();
    const {
      indexPattern
    } = await (0, _index_patterns_utils.fetchIndexPattern)(this.props.model.index_pattern, dataViews);
    this.setState({
      fieldFormatMap: indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.fieldFormatMap,
      indexPattern
    });
  }
  render() {
    const {
      visData,
      model,
      getConfig
    } = this.props;
    if (!visData) {
      return null;
    }
    const series = _lodash.default.get(visData, `${model.id}.series`, []);
    const variables = (0, _convert_series_to_vars.convertSeriesToVars)(series, model, getConfig, this.state.fieldFormatMap, this.state.indexPattern);
    const rows = [];
    const rawFormatter = (0, _tick_formatter.createTickFormatter)('0.[0000]', null, getConfig);
    const createPrimitiveRow = key => {
      const snippet = `{{ ${key} }}`;
      let value = _lodash.default.get(variables, key);
      if (/raw$/.test(key)) value = rawFormatter(value);
      rows.push(/*#__PURE__*/_react.default.createElement("tr", {
        key: key
      }, /*#__PURE__*/_react.default.createElement("td", null, /*#__PURE__*/_react.default.createElement("a", {
        onClick: this.handleVarClick(snippet)
      }, snippet)), /*#__PURE__*/_react.default.createElement("td", null, /*#__PURE__*/_react.default.createElement("code", null, "\u201C", value, "\u201D"))));
    };
    const createArrayRow = key => {
      const snippet = `{{# ${key} }}{{/ ${key} }}`;
      const date = _lodash.default.get(variables, `${key}[0][0]`);
      let value = _lodash.default.get(variables, `${key}[0][1]`);
      if (/raw$/.test(key)) value = rawFormatter(value);
      rows.push(/*#__PURE__*/_react.default.createElement("tr", {
        key: key
      }, /*#__PURE__*/_react.default.createElement("td", null, /*#__PURE__*/_react.default.createElement("a", {
        onClick: this.handleVarClick(snippet)
      }, `{{ ${key} }}`)), /*#__PURE__*/_react.default.createElement("td", null, /*#__PURE__*/_react.default.createElement("code", null, "[ [ \u201C", date, "\u201D, \u201C", value, "\u201D ], ... ]"))));
    };
    function walk(obj, path = []) {
      for (const name in obj) {
        if (Array.isArray(obj[name])) {
          createArrayRow(path.concat(name).join('.'));
        } else if (_lodash.default.isObject(obj[name])) {
          walk(obj[name], path.concat(name));
        } else {
          createPrimitiveRow(path.concat(name).join('.'));
        }
      }
    }
    walk(variables);
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbMarkdownEditor",
      css: editorStyle
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbMarkdownEditor__editor",
      css: [panelStyle, editorPanelStyle]
    }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
      editorDidMount: this.handleOnLoad,
      languageId: _codeEditor.MarkdownLang,
      options: {
        fontSize: '14px',
        wordWrap: 'on'
      },
      value: model.markdown,
      onChange: this.handleChange
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbMarkdownEditor__variables",
      css: [panelStyle, variablesPanelStyle]
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.markdownEditor.howToUseVariablesInMarkdownDescription",
      defaultMessage: "The following variables can be used in the Markdown by using the Handlebar (mustache) syntax. {handlebarLink} on the available expressions.",
      values: {
        handlebarLink: /*#__PURE__*/_react.default.createElement("a", {
          href: "https://ela.st/handlebars-docs",
          target: "_BLANK",
          rel: "noreferrer noopener"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "visTypeTimeseries.markdownEditor.howUseVariablesInMarkdownDescription.documentationLinkText",
          defaultMessage: "Click here for documentation"
        }))
      }
    }))), /*#__PURE__*/_react.default.createElement("table", {
      className: "table",
      "data-test-subj": "tsvbMarkdownVariablesTable"
    }, /*#__PURE__*/_react.default.createElement("thead", null, /*#__PURE__*/_react.default.createElement("tr", null, /*#__PURE__*/_react.default.createElement("th", {
      scope: "col"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.markdownEditor.nameLabel",
      defaultMessage: "Name"
    })), /*#__PURE__*/_react.default.createElement("th", {
      scope: "col"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.markdownEditor.valueLabel",
      defaultMessage: "Value"
    })))), /*#__PURE__*/_react.default.createElement("tbody", null, rows)), rows.length === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      className: "tsvbMarkdownVariablesTable__noVariables",
      "data-test-subj": "tvbMarkdownEditor__noVariables",
      css: noVariablesStyle
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.markdownEditor.noVariablesAvailableDescription",
      defaultMessage: "No variables available for the selected data metrics."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.markdownEditor.howToAccessEntireTreeDescription",
      defaultMessage: "There is also a special variable named {all} which you can use to access the entire tree. This is useful for creating lists with data from a group by:",
      values: {
        all: /*#__PURE__*/_react.default.createElement("code", null, "_all")
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, null, `# All servers:

    {{#each _all}}
    - {{ label }} {{ last.formatted }}
    {{/each}}`)));
  }
}
exports.MarkdownEditor = MarkdownEditor;
MarkdownEditor.propTypes = {
  onChange: _propTypes.default.func,
  model: _propTypes.default.object,
  getConfig: _propTypes.default.func,
  visData: _propTypes.default.object
};