"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTagCloudVisTypeDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _get_tag_cloud_options = require("./components/get_tag_cloud_options");
var _to_ast = require("./to_ast");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getTagCloudVisTypeDefinition = ({
  palettes
}) => {
  return {
    name: 'tagcloud',
    title: _i18n.i18n.translate('visTypeTagCloud.vis.tagCloudTitle', {
      defaultMessage: 'Tag cloud'
    }),
    icon: 'visTagCloud',
    getSupportedTriggers: () => {
      return [_public2.VIS_EVENT_TO_TRIGGER.filter];
    },
    description: _i18n.i18n.translate('visTypeTagCloud.vis.tagCloudDescription', {
      defaultMessage: 'Display word frequency with font size.'
    }),
    visConfig: {
      defaults: {
        scale: 'linear',
        orientation: 'single',
        minFontSize: 18,
        maxFontSize: 72,
        showLabel: true,
        palette: {
          name: 'default',
          type: 'palette'
        }
      }
    },
    fetchDatatable: true,
    toExpressionAst: _to_ast.toExpressionAst,
    editorConfig: {
      enableDataViewChange: true,
      optionsTemplate: (0, _get_tag_cloud_options.getTagCloudOptions)({
        palettes
      }),
      schemas: [{
        group: _public.AggGroupNames.Metrics,
        name: 'metric',
        title: _i18n.i18n.translate('visTypeTagCloud.vis.schemas.metricTitle', {
          defaultMessage: 'Tag size'
        }),
        min: 1,
        max: 1,
        aggFilter: ['!std_dev', '!percentiles', '!percentile_ranks', '!derivative', '!geo_bounds', '!geo_centroid', '!filtered_metric', '!single_percentile', '!single_percentile_rank'],
        defaults: [{
          schema: 'metric',
          type: 'count'
        }]
      }, {
        group: _public.AggGroupNames.Buckets,
        name: 'segment',
        title: _i18n.i18n.translate('visTypeTagCloud.vis.schemas.segmentTitle', {
          defaultMessage: 'Tags'
        }),
        min: 1,
        max: 1,
        aggFilter: ['terms', 'significant_terms']
      }]
    },
    requiresSearch: true,
    navigateToLens: async (vis, timefilter) => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./convert_to_lens')));
      return vis ? convertToLens(vis, timefilter) : null;
    },
    getExpressionVariables: async (vis, timeFilter) => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./convert_to_lens')));
      return {
        canNavigateToLens: Boolean(vis !== null && vis !== void 0 && vis.params ? await convertToLens(vis, timeFilter) : null)
      };
    }
  };
};
exports.getTagCloudVisTypeDefinition = getTagCloudVisTypeDefinition;